/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoublePrimitiveFieldHandler
implements FieldHandler<Double, FieldUpdateEvent<Double>, ReflectionFormBuilder, JSpinner> {
    private static final DoublePrimitiveFieldHandler INSTANCE = new DoublePrimitiveFieldHandler();

    public static DoublePrimitiveFieldHandler getInstance() {
        return INSTANCE;
    }

    protected DoublePrimitiveFieldHandler() {
    }

    @Override
    public JComponent handle(Field field, Object instance, final FieldUpdateListener<FieldUpdateEvent<Double>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        double fieldValue;
        try {
            fieldValue = field.getDouble(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        JSpinner retValue = new JSpinner(new SpinnerNumberModel(fieldValue, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        retValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                updateListener.onUpdate(new FieldUpdateEvent<Double>((Double)((JSpinner)e.getSource()).getValue()));
            }
        });
        return retValue;
    }

    @Override
    public void reset(JSpinner component) {
        component.setValue(0);
    }
}

