/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.panels.DoublePanel;
import de.richtercloud.reflection.form.builder.typehandler.DoubleTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;

public class DoubleFieldHandler
implements FieldHandler<Double, FieldUpdateEvent<Double>, ReflectionFormBuilder, DoublePanel> {
    private static final DoubleFieldHandler INSTANCE = new DoubleFieldHandler();
    private final DoubleTypeHandler doubleTypeHandler;

    public static DoubleFieldHandler getInstance() {
        return INSTANCE;
    }

    protected DoubleFieldHandler() {
        this(DoubleTypeHandler.getInstance());
    }

    public DoubleFieldHandler(DoubleTypeHandler doubleTypeHandler) {
        this.doubleTypeHandler = doubleTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Double>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Double fieldValue;
        try {
            fieldValue = (Double)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.doubleTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(DoublePanel component) {
        component.reset();
    }
}

