/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.components.date.UtilDatePicker;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.DateTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;
import javax.swing.JComponent;

public class DateFieldHandler
implements FieldHandler<Date, FieldUpdateEvent<Date>, ReflectionFormBuilder, UtilDatePicker> {
    private static final DateFieldHandler INSTANCE = new DateFieldHandler();
    private final DateTypeHandler dateTypeHandler;

    public static DateFieldHandler getInstance() {
        return INSTANCE;
    }

    protected DateFieldHandler() {
        this(DateTypeHandler.getInstance());
    }

    public DateFieldHandler(DateTypeHandler dateTypeHandler) {
        this.dateTypeHandler = dateTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Date>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Date fieldValue;
        try {
            fieldValue = (Date)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.dateTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(UtilDatePicker component) {
        component.reset();
    }
}

