/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class BooleanPrimitiveFieldHandler
implements FieldHandler<Boolean, FieldUpdateEvent<Boolean>, ReflectionFormBuilder, JCheckBox> {
    private static final BooleanPrimitiveFieldHandler INSTANCE = new BooleanPrimitiveFieldHandler();

    public static BooleanPrimitiveFieldHandler getInstance() {
        return INSTANCE;
    }

    protected BooleanPrimitiveFieldHandler() {
    }

    @Override
    public JComponent handle(Field field, Object instance, final FieldUpdateListener<FieldUpdateEvent<Boolean>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        boolean fieldValue;
        try {
            fieldValue = field.getBoolean(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        final JCheckBox retValue = new JCheckBox("", fieldValue);
        retValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                updateListener.onUpdate(new FieldUpdateEvent<Boolean>(retValue.isSelected()));
            }
        });
        return retValue;
    }

    @Override
    public void reset(JCheckBox component) {
        component.setSelected(false);
    }
}

