/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.components.BooleanWrapperComboBox;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.BooleanTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;

public class BooleanFieldHandler
implements FieldHandler<Boolean, FieldUpdateEvent<Boolean>, ReflectionFormBuilder, BooleanWrapperComboBox> {
    private static final BooleanFieldHandler INSTANCE = new BooleanFieldHandler();
    private final BooleanTypeHandler booleanTypeHandler;

    public static BooleanFieldHandler getInstance() {
        return INSTANCE;
    }

    protected BooleanFieldHandler() {
        this(BooleanTypeHandler.getInstance());
    }

    public BooleanFieldHandler(BooleanTypeHandler stringTypeHandler) {
        this.booleanTypeHandler = stringTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Boolean>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Boolean fieldValue;
        try {
            fieldValue = (Boolean)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.booleanTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(BooleanWrapperComboBox component) {
        component.setSelectedItem(Boolean.FALSE);
    }
}

