/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorage;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorageException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetriever;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrieverException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyPanel;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.lang.reflect.Field;
import javax.measure.unit.Unit;
import javax.swing.JComponent;
import org.jscience.economics.money.Currency;
import org.jscience.economics.money.Money;
import org.jscience.physics.amount.Amount;

public class AmountMoneyFieldHandler
implements FieldHandler<Amount<Money>, FieldUpdateEvent<Amount<Money>>, ReflectionFormBuilder, AmountMoneyPanel> {
    private final AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever;
    private final AmountMoneyCurrencyStorage amountMoneyCurrencyStorage;
    private final MessageHandler messageHandler;

    public AmountMoneyFieldHandler(AmountMoneyExchangeRateRetriever amountMoneyConversionRateRetriever, AmountMoneyCurrencyStorage amountMoneyCurrencyStorage, MessageHandler messageHandler) {
        this.amountMoneyExchangeRateRetriever = amountMoneyConversionRateRetriever;
        this.amountMoneyCurrencyStorage = amountMoneyCurrencyStorage;
        this.messageHandler = messageHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Amount<Money>>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        AmountMoneyPanel retValue;
        try {
            Amount fieldValue = (Amount)field.get(instance);
            retValue = new AmountMoneyPanel((Amount<Money>)fieldValue, this.amountMoneyCurrencyStorage, this.amountMoneyExchangeRateRetriever, this.messageHandler);
        }
        catch (AmountMoneyCurrencyStorageException | AmountMoneyExchangeRateRetrieverException | IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        retValue.addUpdateListener(amountMoneyPanelUpdateEvent -> updateListener.onUpdate(new FieldUpdateEvent(amountMoneyPanelUpdateEvent.getNewValue())));
        return retValue;
    }

    @Override
    public void reset(AmountMoneyPanel component) {
        Amount fieldResetValue = Amount.valueOf((double)0.0, (Unit)Currency.getReferenceCurrency());
        component.setValue(fieldResetValue);
    }
}

