/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.panels.AbstractListPanel;
import de.richtercloud.reflection.form.builder.typehandler.TypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractListFieldHandler<T, E extends FieldUpdateEvent<T>, R extends ReflectionFormBuilder>
implements FieldHandler<T, E, R, AbstractListPanel> {
    private final MessageHandler messageHandler;
    private final TypeHandler<T, E, R, AbstractListPanel> typeHandler;

    public AbstractListFieldHandler(MessageHandler messageHandler, TypeHandler<T, E, R, AbstractListPanel> typeHandler) {
        this.messageHandler = messageHandler;
        this.typeHandler = typeHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<E> updateListener, R reflectionFormBuilder) throws FieldHandlingException, ResetException {
        Pair<JComponent, ComponentHandler<?>> retValue;
        Type fieldGenericType = field.getGenericType();
        try {
            retValue = this.typeHandler.handle(fieldGenericType, field.get(instance), field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        return (JComponent)retValue.getKey();
    }

    @Override
    public void reset(AbstractListPanel component) throws ResetException {
        this.typeHandler.reset(component);
    }
}

