/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrievalException;
import de.richtercloud.reflection.form.builder.components.money.CachedOnlineAmountMoneyExchangeRateRetriever;
import de.richtercloud.reflection.form.builder.components.money.FixerJsonResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jscience.economics.money.Currency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixerAmountMoneyExchangeRateRetriever
extends CachedOnlineAmountMoneyExchangeRateRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixerAmountMoneyExchangeRateRetriever.class);
    private static final String FIXER_URL = "http://api.fixer.io/latest";
    public static final String INITIAL_RESOURCE_RESOURCE_NAME_DEFAULT = "/fixer-initial-result.xml";

    public FixerAmountMoneyExchangeRateRetriever(File fileCacheFile) {
        super(fileCacheFile, INITIAL_RESOURCE_RESOURCE_NAME_DEFAULT);
    }

    public FixerAmountMoneyExchangeRateRetriever(File fileCacheFile, long fileCacheExpirationMillis) {
        super(fileCacheFile, fileCacheExpirationMillis, INITIAL_RESOURCE_RESOURCE_NAME_DEFAULT);
    }

    private FixerJsonResponse retrieveResponse() throws AmountMoneyExchangeRateRetrievalException {
        try {
            URLConnection uRLConnection = new URL(FIXER_URL).openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            String responseJsonString = IOUtils.toString((InputStream)inputStream);
            LOGGER.debug(String.format("%s replied: %s", FIXER_URL, responseJsonString));
            return (FixerJsonResponse)new ObjectMapper().readValue(responseJsonString, FixerJsonResponse.class);
        }
        catch (IOException ex) {
            throw new AmountMoneyExchangeRateRetrievalException(ex);
        }
    }

    @Override
    protected Pair<Map<Currency, Double>, Currency> fetchResult() throws AmountMoneyExchangeRateRetrievalException {
        HashMap<Currency, Double> exchangeRates = new HashMap<Currency, Double>();
        FixerJsonResponse fixerJsonResponse = this.retrieveResponse();
        for (String currencyCode : fixerJsonResponse.getRates().keySet()) {
            Currency currency = new Currency(currencyCode);
            Double exchangeRate = fixerJsonResponse.getRates().get(currencyCode);
            assert (exchangeRate != null);
            exchangeRates.put(currency, exchangeRate);
        }
        exchangeRates.put(new Currency(fixerJsonResponse.getBase()), 1.0);
        return new ImmutablePair(exchangeRates, (Object)new Currency(fixerJsonResponse.getBase()));
    }

    @Override
    protected String getUrl() {
        return FIXER_URL;
    }
}

