/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import de.richtercloud.reflection.form.builder.components.money.AmountMoneyUsageStatisticsStorage;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyUsageStatisticsStorageException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.Properties;
import org.jscience.economics.money.Currency;

public class FileAmountMoneyUsageStatisticsStorage
implements AmountMoneyUsageStatisticsStorage {
    private final File file;
    private final Properties properties;

    public FileAmountMoneyUsageStatisticsStorage(File file) throws IOException {
        this.file = file;
        this.properties = new Properties();
        if (file.exists()) {
            this.properties.loadFromXML(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
    }

    @Override
    public int getUsageCount(Currency currency) {
        return Integer.valueOf(this.properties.getProperty(currency.getCode()));
    }

    @Override
    public void reset(Currency currency) throws AmountMoneyUsageStatisticsStorageException {
        this.properties.remove(currency);
        try {
            this.properties.storeToXML(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), new Date().toString());
        }
        catch (IOException ex) {
            throw new AmountMoneyUsageStatisticsStorageException(ex);
        }
    }

    @Override
    public void incrementUsageCount(Currency currency) throws AmountMoneyUsageStatisticsStorageException {
        int usageCount = this.getUsageCount(currency);
        this.properties.setProperty(currency.getCode(), String.valueOf(usageCount + 1));
        try {
            this.properties.storeToXML(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), new Date().toString());
        }
        catch (IOException ex) {
            throw new AmountMoneyUsageStatisticsStorageException(ex);
        }
    }
}

