/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.richtercloud.reflection.form.builder.components.money.AbstractAmountMoneyCurrencyStorage;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyComponent;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorageException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import javax.measure.converter.ConversionException;
import org.jscience.economics.money.Currency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAmountMoneyCurrencyStorage
extends AbstractAmountMoneyCurrencyStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAmountMoneyCurrencyStorage.class);
    private static final String CURRENCY_CODE_ATTRIBUTE_NAME = "code";
    private static final String CURRENCY_EXCHANGE_RATE_ATTRIBUTE_NAME = "exchangeRate";
    private static final Converter CURRENCY_CONVERTER = new Converter(){

        public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mc) {
            Currency currency = (Currency)o;
            writer.addAttribute(FileAmountMoneyCurrencyStorage.CURRENCY_CODE_ATTRIBUTE_NAME, currency.getCode());
            try {
                writer.addAttribute(FileAmountMoneyCurrencyStorage.CURRENCY_EXCHANGE_RATE_ATTRIBUTE_NAME, String.valueOf(currency.getExchangeRate()));
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext uc) {
            String code = reader.getAttribute(FileAmountMoneyCurrencyStorage.CURRENCY_CODE_ATTRIBUTE_NAME);
            Currency currency = new Currency(code);
            String exchangeRateString = reader.getAttribute(FileAmountMoneyCurrencyStorage.CURRENCY_EXCHANGE_RATE_ATTRIBUTE_NAME);
            if (exchangeRateString != null) {
                double exchangeRate = Double.valueOf(exchangeRateString);
                currency.setExchangeRate(exchangeRate);
            }
            return currency;
        }

        public boolean canConvert(Class type) {
            return Currency.class.isAssignableFrom(type);
        }
    };
    private final File file;

    public FileAmountMoneyCurrencyStorage(File file) {
        this.file = file;
    }

    @Override
    public Set<Currency> getCurrencies() throws AmountMoneyCurrencyStorageException {
        if (!this.file.exists()) {
            LOGGER.info(String.format("Currency storage file '%s' doesn't exist, creating it with default currencies", this.file));
            if (!this.file.getParentFile().exists()) {
                try {
                    Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new AmountMoneyCurrencyStorageException(String.format("Currency storage file's parent directory '%s' couldn't be created", this.file.getParentFile()), ex);
                }
            }
            this.saveCurrencies(AmountMoneyComponent.DEFAULT_CURRENCIES);
        }
        try {
            InputStream inputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            XStream xStream = new XStream();
            xStream.registerConverter(CURRENCY_CONVERTER);
            Set currencies = (Set)xStream.fromXML(inputStream);
            if (currencies.isEmpty()) {
                LOGGER.info(String.format("Currency storage file '%s' contains 0 currency, using default currencies", this.file));
                this.saveCurrencies(AmountMoneyComponent.DEFAULT_CURRENCIES);
                return AmountMoneyComponent.DEFAULT_CURRENCIES;
            }
            return currencies;
        }
        catch (IOException ex) {
            throw new AmountMoneyCurrencyStorageException(ex);
        }
    }

    private void saveCurrencies(Set<Currency> currencies) throws AmountMoneyCurrencyStorageException {
        try (OutputStream outputStream = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);){
            XStream xStream = new XStream();
            xStream.registerConverter(CURRENCY_CONVERTER);
            xStream.toXML(currencies, outputStream);
            outputStream.flush();
        }
        catch (IOException ex) {
            throw new AmountMoneyCurrencyStorageException(ex);
        }
    }

    @Override
    public void saveCurrency(Currency currency) throws AmountMoneyCurrencyStorageException {
        Set<Currency> additionalCurrencies = this.getCurrencies();
        additionalCurrencies.add(currency);
        this.saveCurrencies(additionalCurrencies);
    }

    @Override
    public void removeCurrency(Currency currency) throws AmountMoneyCurrencyStorageException {
        Set<Currency> currentCurrencies = this.getCurrencies();
        currentCurrencies.remove(currency);
        try (OutputStream outputStream = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);){
            XStream xStream = new XStream();
            xStream.registerConverter(CURRENCY_CONVERTER);
            xStream.toXML(currentCurrencies, outputStream);
            outputStream.flush();
        }
        catch (IOException ex) {
            throw new AmountMoneyCurrencyStorageException(ex);
        }
    }
}

