/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetriever;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrieverException;
import de.richtercloud.reflection.form.builder.components.money.ECBAmountMoneyExchangeRateRetriever;
import de.richtercloud.reflection.form.builder.components.money.FixerAmountMoneyExchangeRateRetriever;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.jscience.economics.money.Currency;

public class FailsafeAmountMoneyExchangeRateRetriever
implements AmountMoneyExchangeRateRetriever {
    public static final int AVAILABLE_RETRIEVER_MIN_DEFAULT = 1;
    private final Queue<AmountMoneyExchangeRateRetriever> retrieverQueue = new LinkedList<AmountMoneyExchangeRateRetriever>();
    private final int availableRetrieverMin;

    public FailsafeAmountMoneyExchangeRateRetriever(File cacheFileDir) throws IOException {
        this(1, cacheFileDir, 3600000L);
    }

    public FailsafeAmountMoneyExchangeRateRetriever(File cacheFileDir, long fileCacheExpirationMillis) throws IOException {
        this(1, cacheFileDir, fileCacheExpirationMillis);
    }

    public FailsafeAmountMoneyExchangeRateRetriever(int availableRetrieverMin, File cacheFileDir, long fileCacheExpirationMillis) throws IOException {
        this.availableRetrieverMin = availableRetrieverMin;
        if (cacheFileDir == null) {
            throw new IllegalArgumentException("fileCacheFileDir mustn't be null");
        }
        if (cacheFileDir.exists()) {
            if (!cacheFileDir.isDirectory()) {
                throw new IllegalArgumentException("fileCacheFileDir exists, but is no directory");
            }
        } else {
            FileUtils.forceMkdir((File)cacheFileDir);
        }
        File fixerCacheFile = new File(cacheFileDir, "fixer.xml");
        File eCBCacheFile = new File(cacheFileDir, "ecb.xml");
        FixerAmountMoneyExchangeRateRetriever fixerAmountMoneyExchangeRateRetriever = new FixerAmountMoneyExchangeRateRetriever(fixerCacheFile, fileCacheExpirationMillis);
        ECBAmountMoneyExchangeRateRetriever eCBAmountMoneyExchangeRateRetriever = new ECBAmountMoneyExchangeRateRetriever(eCBCacheFile, fileCacheExpirationMillis);
        this.retrieverQueue.add(fixerAmountMoneyExchangeRateRetriever);
        this.retrieverQueue.add(eCBAmountMoneyExchangeRateRetriever);
    }

    public FailsafeAmountMoneyExchangeRateRetriever(Set<AmountMoneyExchangeRateRetriever> fallbackRetrievers) {
        this(1, fallbackRetrievers);
    }

    public FailsafeAmountMoneyExchangeRateRetriever(int availableRetrieverMin, Set<AmountMoneyExchangeRateRetriever> fallbackRetrievers) {
        this.availableRetrieverMin = availableRetrieverMin;
        this.retrieverQueue.addAll(fallbackRetrievers);
    }

    @Override
    public Set<Currency> getSupportedCurrencies() throws AmountMoneyExchangeRateRetrieverException {
        assert (this.retrieverQueue.size() >= 2);
        HashSet<Currency> retValue = new HashSet<Currency>();
        int availableRetrieverCount = 0;
        for (AmountMoneyExchangeRateRetriever retriever : this.retrieverQueue) {
            try {
                Set<Currency> retrieverSupportedCurrencies = retriever.getSupportedCurrencies();
                retValue.addAll(retrieverSupportedCurrencies);
                ++availableRetrieverCount;
            }
            catch (AmountMoneyExchangeRateRetrieverException amountMoneyExchangeRateRetrieverException) {}
        }
        if (availableRetrieverCount < this.availableRetrieverMin) {
            throw new AmountMoneyExchangeRateRetrieverException(String.format("Only %d of %d required retrievers were available", availableRetrieverCount, this.availableRetrieverMin));
        }
        return retValue;
    }

    @Override
    public void retrieveExchangeRate(Currency currency) throws AmountMoneyExchangeRateRetrieverException {
        for (AmountMoneyExchangeRateRetriever retriever : this.retrieverQueue) {
            try {
                retriever.retrieveExchangeRate(currency);
                return;
            }
            catch (AmountMoneyExchangeRateRetrieverException amountMoneyExchangeRateRetrieverException) {
            }
        }
        throw new AmountMoneyExchangeRateRetrieverException("all retrievers failed to retrieve exchange rate");
    }
}

