/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrievalException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrieverException;
import de.richtercloud.reflection.form.builder.components.money.CachedOnlineAmountMoneyExchangeRateRetriever;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jscience.economics.money.Currency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ECBAmountMoneyExchangeRateRetriever
extends CachedOnlineAmountMoneyExchangeRateRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(ECBAmountMoneyExchangeRateRetriever.class);
    private static final String ECB_URL = "https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml";
    private static final Currency REFERENCE_CURRENCY = Currency.EUR;
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    public static final String INITIAL_RESOURCE_RESOURCE_NAME_DEFAULT = "/ecb-initial-result.xml";

    public ECBAmountMoneyExchangeRateRetriever(File fileCacheFile) {
        super(fileCacheFile, INITIAL_RESOURCE_RESOURCE_NAME_DEFAULT);
    }

    public ECBAmountMoneyExchangeRateRetriever(File fileCacheFile, long fileCacheExpirationMillis) {
        super(fileCacheFile, fileCacheExpirationMillis, INITIAL_RESOURCE_RESOURCE_NAME_DEFAULT);
    }

    private Map<Currency, Double> retrieveResponse() throws AmountMoneyExchangeRateRetrieverException, AmountMoneyExchangeRateRetrievalException {
        HashMap<Currency, Double> retValue = new HashMap<Currency, Double>();
        try {
            URLConnection uRLConnection = new URL(ECB_URL).openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            String responseXMLString = IOUtils.toString((InputStream)inputStream);
            LOGGER.debug(String.format("%s replied: %s", ECB_URL, responseXMLString));
            DocumentBuilder builder = FACTORY.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(responseXMLString)));
            Element rootNode = document.getDocumentElement();
            NodeList rootNodeChildren = rootNode.getChildNodes();
            Node cubeNode = null;
            for (int i = 0; i < rootNodeChildren.getLength(); ++i) {
                if (!"Cube".equals(rootNodeChildren.item(i).getNodeName())) continue;
                cubeNode = rootNodeChildren.item(i);
            }
            if (cubeNode == null) {
                throw new IllegalStateException("XML response didn't contain a Cube element");
            }
            Node cubeCubeNode = null;
            NodeList cubeNodeChildren = cubeNode.getChildNodes();
            for (int i = 0; i < cubeNodeChildren.getLength(); ++i) {
                if (!"Cube".equals(cubeNodeChildren.item(i).getNodeName())) continue;
                cubeCubeNode = cubeNodeChildren.item(i);
            }
            if (cubeCubeNode == null) {
                throw new IllegalStateException("XML response didn't contain a Cube element in the topmost Cube element");
            }
            NodeList cubeCubeNodeChildren = cubeCubeNode.getChildNodes();
            for (int i = 0; i < cubeCubeNodeChildren.getLength(); ++i) {
                Node cubeCubeNodeChild = cubeCubeNodeChildren.item(i);
                if (!"Cube".equals(cubeCubeNodeChild.getNodeName())) continue;
                Node cubeCubeNodeChildCurrencyAttribute = cubeCubeNodeChild.getAttributes().getNamedItem("currency");
                if (cubeCubeNodeChildCurrencyAttribute == null) {
                    throw new IllegalStateException("XML response contains Cube element without currency attribute");
                }
                Node cubeCubeNodeChildRateAttribute = cubeCubeNodeChild.getAttributes().getNamedItem("rate");
                String currencyCode = cubeCubeNodeChildCurrencyAttribute.getNodeValue();
                Double rate = Double.valueOf(cubeCubeNodeChildRateAttribute.getNodeValue());
                Currency currency = new Currency(currencyCode);
                retValue.put(currency, rate);
            }
            return retValue;
        }
        catch (IOException ex) {
            throw new AmountMoneyExchangeRateRetrievalException(ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new AmountMoneyExchangeRateRetrieverException(ex);
        }
    }

    @Override
    protected Pair<Map<Currency, Double>, Currency> fetchResult() throws AmountMoneyExchangeRateRetrieverException, AmountMoneyExchangeRateRetrievalException {
        Map<Currency, Double> response = this.retrieveResponse();
        response.put(REFERENCE_CURRENCY, 1.0);
        return new ImmutablePair(response, (Object)REFERENCE_CURRENCY);
    }

    @Override
    protected String getUrl() {
        return ECB_URL;
    }
}

