/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import com.thoughtworks.xstream.XStream;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrievalException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrieverException;
import de.richtercloud.reflection.form.builder.components.money.OnlineAmountMoneyExchangeRateRetriever;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jscience.economics.money.Currency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedOnlineAmountMoneyExchangeRateRetriever
extends OnlineAmountMoneyExchangeRateRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedOnlineAmountMoneyExchangeRateRetriever.class);
    public static final long FILE_CACHE_EXPIRATION_MILLIS_DEFAULT = 3600000L;
    private Pair<Map<Currency, Double>, Currency> result;
    private Date fileCacheTimestamp;
    private final File fileCacheFile;
    private final long fileCacheExpirationMillis;
    private final String initialResultResourceName;

    public CachedOnlineAmountMoneyExchangeRateRetriever(File fileCacheFile, String initialResultResourceName) {
        this(fileCacheFile, 3600000L, initialResultResourceName);
    }

    public CachedOnlineAmountMoneyExchangeRateRetriever(File fileCacheFile, long fileCacheExpirationMillis, String initialResultResourceName) {
        this.fileCacheFile = fileCacheFile;
        this.fileCacheExpirationMillis = fileCacheExpirationMillis;
        if (initialResultResourceName == null) {
            throw new IllegalArgumentException("initialResultResourceName mustn't be null");
        }
        this.initialResultResourceName = initialResultResourceName;
    }

    public Pair<Map<Currency, Double>, Currency> getResult() throws AmountMoneyExchangeRateRetrieverException {
        Date timestampNew = new Date();
        XStream xStream = new XStream();
        if (this.result == null) {
            if (!this.fileCacheFile.exists()) {
                this.fileCacheTimestamp = timestampNew;
                try {
                    this.result = this.fetchResult();
                }
                catch (AmountMoneyExchangeRateRetrievalException ex) {
                    InputStream initialResultInputStream = CachedOnlineAmountMoneyExchangeRateRetriever.class.getResourceAsStream(this.initialResultResourceName);
                    Pair serializedResult = (Pair)xStream.fromXML(initialResultInputStream);
                    this.fileCacheTimestamp = (Date)serializedResult.getKey();
                    this.result = (Pair)serializedResult.getValue();
                }
                try {
                    xStream.toXML((Object)new ImmutablePair((Object)timestampNew, this.result), Files.newOutputStream(this.fileCacheFile.toPath(), new OpenOption[0]));
                }
                catch (IOException ex) {
                    throw new AmountMoneyExchangeRateRetrieverException(ex);
                }
            }
            LOGGER.debug(String.format("using cached result from '%s'", this.fileCacheFile.getAbsolutePath()));
            Pair serializedResult = (Pair)xStream.fromXML(this.fileCacheFile);
            this.fileCacheTimestamp = (Date)serializedResult.getKey();
            this.result = (Pair)serializedResult.getValue();
        }
        if (timestampNew.getTime() - this.fileCacheTimestamp.getTime() > this.fileCacheExpirationMillis) {
            try {
                this.result = this.fetchResult();
            }
            catch (AmountMoneyExchangeRateRetrievalException ex) {
                return this.result;
            }
            try {
                xStream.toXML((Object)new ImmutablePair((Object)timestampNew, this.result), Files.newOutputStream(this.fileCacheFile.toPath(), new OpenOption[0]));
            }
            catch (IOException ex) {
                throw new AmountMoneyExchangeRateRetrieverException(ex);
            }
            this.fileCacheTimestamp = timestampNew;
        }
        return this.result;
    }

    protected abstract Pair<Map<Currency, Double>, Currency> fetchResult() throws AmountMoneyExchangeRateRetrieverException, AmountMoneyExchangeRateRetrievalException;

    @Override
    public Set<Currency> getSupportedCurrencies() throws AmountMoneyExchangeRateRetrieverException {
        Set retValue = ((Map)this.getResult().getKey()).keySet();
        return Collections.unmodifiableSet(retValue);
    }

    @Override
    public double fetchConversionRate(Currency currency) throws AmountMoneyExchangeRateRetrieverException {
        Pair<Map<Currency, Double>, Currency> result0 = this.getResult();
        assert (result0 != null);
        if (Currency.getReferenceCurrency() == null) {
            Currency.setReferenceCurrency((Currency)((Currency)result0.getValue()));
        } else if (!Currency.getReferenceCurrency().equals(result0.getValue())) {
            throw new IllegalStateException("Online response base/reference currency changed");
        }
        if (currency.equals(result0.getValue())) {
            return 1.0;
        }
        Double retValue = (Double)((Map)result0.getKey()).get(currency);
        if (retValue == null) {
            throw new AmountMoneyExchangeRateRetrieverException(String.format("The API response from URL %s didn't contain the key for the currency %s", this.getUrl(), currency));
        }
        return retValue;
    }

    protected abstract String getUrl();
}

