/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyComponentEditDialog;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorage;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorageException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetriever;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jscience.economics.money.Currency;

public class AmountMoneyComponentManageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String CURRENCY_STORAGE_EXCEPTION_TEMPLATE = "An exception occured during retrieval of currencies from the storage: %s";
    private static final String CURRENCY_STORAGE_EXCEPTION_SUMMARY = "Exception during currency storage occured";
    private final AmountMoneyCurrencyStorage amountMoneyCurrencyStorage;
    private final AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever;
    private final DefaultListModel<Currency> currencyListModel = new DefaultListModel();
    private final MessageHandler messageHandler;
    private JButton addButton;
    private JButton closeButton;
    private JList<Currency> currencyList;
    private JScrollPane currencyListScrollPane;
    private JButton editButton;
    private JButton removeButton;
    private JButton resetUsageCountButton;

    public AmountMoneyComponentManageDialog(AmountMoneyCurrencyStorage amountMoneyCurrencyStorage, AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever, MessageHandler messageHandler, Frame parent) throws AmountMoneyCurrencyStorageException {
        super(parent, true);
        for (Currency currency : amountMoneyCurrencyStorage.getCurrencies()) {
            this.currencyListModel.addElement(currency);
        }
        this.amountMoneyCurrencyStorage = amountMoneyCurrencyStorage;
        this.amountMoneyExchangeRateRetriever = amountMoneyExchangeRateRetriever;
        this.messageHandler = messageHandler;
        this.initComponents();
    }

    private void initComponents() {
        this.currencyListScrollPane = new JScrollPane();
        this.currencyList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.resetUsageCountButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.currencyList.setModel(this.currencyListModel);
        this.currencyListScrollPane.setViewportView(this.currencyList);
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponentManageDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponentManageDialog.this.removeButtonActionPerformed(evt);
            }
        });
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponentManageDialog.this.editButtonActionPerformed(evt);
            }
        });
        this.resetUsageCountButton.setText("Reset usage count");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponentManageDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.currencyListScrollPane, -1, 224, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.resetUsageCountButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.editButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetUsageCountButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.currencyListScrollPane, -1, 235, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeButton).addContainerGap()));
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        AmountMoneyComponentEditDialog amountMoneyPanelEditDialog;
        try {
            amountMoneyPanelEditDialog = new AmountMoneyComponentEditDialog(null, this.amountMoneyCurrencyStorage, this.amountMoneyExchangeRateRetriever, (Frame)SwingUtilities.getWindowAncestor(this), this.messageHandler);
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle(new Message(String.format(CURRENCY_STORAGE_EXCEPTION_TEMPLATE, ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, CURRENCY_STORAGE_EXCEPTION_SUMMARY));
            return;
        }
        amountMoneyPanelEditDialog.pack();
        amountMoneyPanelEditDialog.setVisible(true);
        Currency newCurrency = amountMoneyPanelEditDialog.getCurrency();
        try {
            this.amountMoneyCurrencyStorage.saveCurrency(newCurrency);
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle(new Message(String.format(CURRENCY_STORAGE_EXCEPTION_TEMPLATE, ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, CURRENCY_STORAGE_EXCEPTION_SUMMARY));
            return;
        }
        this.currencyListModel.add(0, newCurrency);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Currency selectedCurrency = this.currencyList.getSelectedValue();
        if (selectedCurrency == null) {
            return;
        }
        try {
            this.amountMoneyCurrencyStorage.removeCurrency(selectedCurrency);
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle(new Message(String.format(CURRENCY_STORAGE_EXCEPTION_TEMPLATE, ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, CURRENCY_STORAGE_EXCEPTION_SUMMARY));
            return;
        }
        this.currencyListModel.remove(this.currencyList.getSelectedIndex());
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        AmountMoneyComponentEditDialog amountMoneyPanelEditDialog;
        Currency selectedCurrency = this.currencyList.getSelectedValue();
        try {
            amountMoneyPanelEditDialog = new AmountMoneyComponentEditDialog(selectedCurrency, this.amountMoneyCurrencyStorage, this.amountMoneyExchangeRateRetriever, (Frame)SwingUtilities.getWindowAncestor(this), this.messageHandler);
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle(new Message(String.format(CURRENCY_STORAGE_EXCEPTION_TEMPLATE, ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, CURRENCY_STORAGE_EXCEPTION_SUMMARY));
            return;
        }
        amountMoneyPanelEditDialog.pack();
        amountMoneyPanelEditDialog.setVisible(true);
        Currency editedCurrency = amountMoneyPanelEditDialog.getCurrency();
        try {
            this.amountMoneyCurrencyStorage.removeCurrency(selectedCurrency);
            this.amountMoneyCurrencyStorage.saveCurrency(editedCurrency);
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle(new Message(String.format(CURRENCY_STORAGE_EXCEPTION_TEMPLATE, ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, CURRENCY_STORAGE_EXCEPTION_SUMMARY));
            return;
        }
        int selectedCurrencyIndex = this.currencyListModel.indexOf(selectedCurrency);
        this.currencyListModel.remove(selectedCurrencyIndex);
        this.currencyListModel.add(selectedCurrencyIndex, editedCurrency);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

