/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyComponent;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorage;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorageException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetriever;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrieverException;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.measure.unit.Unit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.jscience.economics.money.Currency;

public class AmountMoneyComponentEditDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final DefaultComboBoxModel<Currency> referenceCurrencyComboBoxModel = new DefaultComboBoxModel();
    private final AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever;
    private Currency currency;
    private final MessageHandler messageHandler;
    private JButton cancelButton;
    private JTextField codeTextField;
    private JLabel codeTextFieldLabel;
    private JSpinner exchangeRateSpinner;
    private JLabel exchangeRateSpinnerLabel;
    private JComboBox<Currency> referenceCurrencyComboBox;
    private JLabel referenceCurrencyComboBoxLabel;
    private JButton saveButton;

    public AmountMoneyComponentEditDialog(Currency currency, AmountMoneyCurrencyStorage amountMoneyCurrencyStorage, AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever, Frame parent, MessageHandler messageHandler) throws AmountMoneyCurrencyStorageException {
        super(parent, true);
        if (messageHandler == null) {
            throw new IllegalArgumentException("messageHandler mustn't be null");
        }
        this.messageHandler = messageHandler;
        if (currency != null) {
            if (!amountMoneyCurrencyStorage.getCurrencies().contains(currency)) {
                throw new IllegalArgumentException(String.format("Currency '%s' isn't managed in amountMoneyCurrencyStorage and thus can't be edited", currency.getCode()));
            }
            this.codeTextField.setText(currency.getCode());
            this.exchangeRateSpinner.setValue(currency.getExchangeRate());
        }
        for (Currency currency0 : amountMoneyCurrencyStorage.getCurrencies()) {
            this.referenceCurrencyComboBoxModel.addElement(currency0);
        }
        this.currency = currency;
        this.amountMoneyExchangeRateRetriever = amountMoneyExchangeRateRetriever;
        this.initComponents();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    private void initComponents() {
        this.codeTextField = new JTextField();
        this.codeTextFieldLabel = new JLabel();
        this.referenceCurrencyComboBox = new JComboBox();
        this.referenceCurrencyComboBoxLabel = new JLabel();
        this.exchangeRateSpinner = new JSpinner();
        this.exchangeRateSpinnerLabel = new JLabel();
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.codeTextFieldLabel.setText("Code");
        this.referenceCurrencyComboBox.setModel(this.referenceCurrencyComboBoxModel);
        this.referenceCurrencyComboBoxLabel.setText("Reference currency");
        this.exchangeRateSpinner.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.exchangeRateSpinner.setValue(1.0);
        this.exchangeRateSpinnerLabel.setText("Exchange rate to reference currency");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponentEditDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponentEditDialog.this.saveButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codeTextFieldLabel).addComponent(this.referenceCurrencyComboBoxLabel).addComponent(this.exchangeRateSpinnerLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceCurrencyComboBox, 0, 100, Short.MAX_VALUE).addComponent(this.codeTextField).addComponent(this.exchangeRateSpinner, GroupLayout.Alignment.TRAILING))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codeTextField, -2, -1, -2).addComponent(this.codeTextFieldLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.referenceCurrencyComboBox, -2, -1, -2).addComponent(this.referenceCurrencyComboBoxLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exchangeRateSpinner, -2, -1, -2).addComponent(this.exchangeRateSpinnerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 153, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.saveButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        String code = this.codeTextField.getText();
        Currency referenceCurrency = (Currency)this.referenceCurrencyComboBox.getSelectedItem();
        Double exchangeRate = (Double)this.exchangeRateSpinner.getValue();
        if (this.currency == null) {
            this.currency = new Currency(code);
        }
        if (Currency.getReferenceCurrency() == null) {
            Currency.setReferenceCurrency((Currency)AmountMoneyComponent.REFERENCE_CURRENCY);
        }
        if (!referenceCurrency.equals((Object)Currency.getReferenceCurrency())) {
            try {
                this.amountMoneyExchangeRateRetriever.retrieveExchangeRate(referenceCurrency);
            }
            catch (AmountMoneyExchangeRateRetrieverException ex) {
                this.messageHandler.handle((Message)new ExceptionMessage((Throwable)ex));
                return;
            }
            exchangeRate = referenceCurrency.getConverterTo((Unit)Currency.getReferenceCurrency()).convert(exchangeRate.doubleValue());
        }
        this.currency.setExchangeRate(exchangeRate.doubleValue());
        this.setVisible(false);
        this.dispose();
    }
}

