/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components.money;

import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyComponentManageDialog;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyComponentUpdateEvent;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyComponentUpdateListener;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorage;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyCurrencyStorageException;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetriever;
import de.richtercloud.reflection.form.builder.components.money.AmountMoneyExchangeRateRetrieverException;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.MutableComboBoxModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jscience.economics.money.Currency;
import org.jscience.economics.money.Money;
import org.jscience.physics.amount.Amount;

public class AmountMoneyComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final MutableComboBoxModel<Currency> currencyComboBoxModel = new DefaultComboBoxModel<Currency>();
    public static final Set<Currency> DEFAULT_CURRENCIES = new HashSet<Currency>(Arrays.asList(Currency.AUD, Currency.CAD, Currency.CNY, Currency.EUR, Currency.GBP, Currency.JPY, Currency.KRW, Currency.USD));
    public static final Currency REFERENCE_CURRENCY = Currency.EUR;
    private final Set<AmountMoneyComponentUpdateListener> updateListeners = new HashSet<AmountMoneyComponentUpdateListener>();
    private final AmountMoneyCurrencyStorage amountMoneyCurrencyStorage;
    private final MessageHandler messageHandler;
    private final AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever;
    private static final float MINIMAL_STEP = 0.01f;
    private static final double INTEGER_SPINNER_MAX_VALUE = 1.7976930946807428E306;
    private JSpinner amountDecimalSpinner;
    private JSpinner amountIntegerSpinner;
    private JLabel amountLabel;
    private JComboBox<Currency> currencyComboBox;
    private JLabel currencyLabel;
    private JButton currencyManageButton;

    public static Currency getReferenceCurrency() {
        if (Currency.getReferenceCurrency() == null) {
            Currency.setReferenceCurrency((Currency)REFERENCE_CURRENCY);
        } else if (!Currency.getReferenceCurrency().equals((Object)REFERENCE_CURRENCY)) {
            throw new IllegalStateException("reference currency has been changed externally");
        }
        return REFERENCE_CURRENCY;
    }

    public AmountMoneyComponent(AmountMoneyCurrencyStorage amountMoneyCurrencyStorage, AmountMoneyExchangeRateRetriever amountMoneyExchangeRateRetriever, MessageHandler messageHandler) throws AmountMoneyExchangeRateRetrieverException, AmountMoneyCurrencyStorageException {
        this.messageHandler = messageHandler;
        if (amountMoneyCurrencyStorage == null) {
            throw new IllegalArgumentException("amountMoneyCurrencyStorage mustn't be null");
        }
        Set<Currency> exchangeRateRetrieverSupportedCurrencies = amountMoneyExchangeRateRetriever.getSupportedCurrencies();
        for (Currency currency : amountMoneyCurrencyStorage.getCurrencies()) {
            if (!exchangeRateRetrieverSupportedCurrencies.contains(currency)) {
                try {
                    currency.getExchangeRate();
                }
                catch (ConversionException ex) {
                    throw new IllegalArgumentException(String.format("Currency %s isn't supported by exchange rate retriever and doesn't have an exchange rate set", currency), ex);
                }
            }
            this.currencyComboBoxModel.addElement(currency);
        }
        this.initComponents();
        ((SpinnerNumberModel)this.amountIntegerSpinner.getModel()).setMaximum(Long.valueOf(Long.MAX_VALUE));
        this.amountIntegerSpinner.addChangeListener(e -> {
            for (AmountMoneyComponentUpdateListener updateListener : this.updateListeners) {
                updateListener.onUpdate(new AmountMoneyComponentUpdateEvent(this.getValue()));
            }
        });
        this.amountDecimalSpinner.addChangeListener(e -> {
            for (AmountMoneyComponentUpdateListener updateListener : this.updateListeners) {
                updateListener.onUpdate(new AmountMoneyComponentUpdateEvent(this.getValue()));
            }
        });
        this.currencyComboBox.addItemListener(itemEvent -> {
            double newAmount;
            Currency oldCurrency = (Currency)itemEvent.getItem();
            Currency newCurrency = (Currency)itemEvent.getItemSelectable().getSelectedObjects()[0];
            try {
                newAmount = oldCurrency.getConverterTo((Unit)newCurrency).convert(this.getAmount());
            }
            catch (ConversionException ex) {
                try {
                    amountMoneyExchangeRateRetriever.retrieveExchangeRate(newCurrency);
                    amountMoneyExchangeRateRetriever.retrieveExchangeRate(oldCurrency);
                    newAmount = oldCurrency.getConverterTo((Unit)newCurrency).convert(this.getAmount());
                }
                catch (AmountMoneyExchangeRateRetrieverException amountMoneyExchangeRateRetrieverException) {
                    messageHandler.handle((Message)new ExceptionMessage((Throwable)amountMoneyExchangeRateRetrieverException));
                    return;
                }
            }
            BigDecimal bd = new BigDecimal(newAmount * 100.0);
            bd = bd.setScale(0, RoundingMode.HALF_UP);
            int bdIntValue = bd.intValue();
            this.amountDecimalSpinner.setValue(bdIntValue % 100);
            if (bd.doubleValue() > newAmount * 100.0) {
                this.amountIntegerSpinner.setValue((int)newAmount + 1);
            } else {
                this.amountIntegerSpinner.setValue((int)newAmount);
            }
            for (AmountMoneyComponentUpdateListener updateListener : this.updateListeners) {
                updateListener.onUpdate(new AmountMoneyComponentUpdateEvent(this.getValue()));
            }
        });
        this.amountMoneyCurrencyStorage = amountMoneyCurrencyStorage;
        this.amountMoneyExchangeRateRetriever = amountMoneyExchangeRateRetriever;
    }

    private double getAmount() {
        return ((Number)this.amountIntegerSpinner.getValue()).doubleValue() + (double)((Number)this.amountDecimalSpinner.getValue()).intValue() / 100.0;
    }

    public Amount<Money> getValue() {
        double amount = this.getAmount();
        return Amount.valueOf((double)amount, (Unit)((Currency)this.currencyComboBoxModel.getSelectedItem()));
    }

    public static Amount<Money> parseValue(String value) {
        Currency currency;
        String valueTrim = value.trim();
        StringBuilder digitsBuilder = new StringBuilder();
        int nonDigitOffset = 0;
        for (char c : valueTrim.toCharArray()) {
            if (!Character.isDigit(c)) break;
            digitsBuilder.append(c);
            ++nonDigitOffset;
        }
        String digits = digitsBuilder.toString();
        double amount = Double.valueOf(digits);
        char[] valueTrail = new char[valueTrim.length() - nonDigitOffset];
        System.arraycopy(valueTrim.toCharArray(), nonDigitOffset, valueTrail, 0, valueTrail.length);
        String valueTrailTrim = new String(valueTrail).trim();
        StringBuilder currencyCodeBuilder = new StringBuilder();
        for (char c : valueTrailTrim.toCharArray()) {
            currencyCodeBuilder.append(c);
        }
        String currencyCode = currencyCodeBuilder.toString();
        try {
            currency = new Currency(currencyCode);
        }
        catch (IllegalArgumentException ex) {
            currency = AmountMoneyComponent.getReferenceCurrency();
        }
        return Amount.valueOf((double)amount, (Unit)currency);
    }

    public void setValue(Amount<Money> value) {
        double amount = value.doubleValue(value.getUnit());
        if (amount >= 1.7976930946807428E306) {
            throw new IllegalArgumentException(String.format("values larger than %f not supported", 1.7976930946807428E306));
        }
        this.amountIntegerSpinner.setValue((long)amount);
        this.amountDecimalSpinner.setValue(amount % 1.0 * 100.0);
        this.currencyComboBox.setSelectedItem(value.getUnit());
    }

    public void addUpdateListener(AmountMoneyComponentUpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void removeUpdateListener(AmountMoneyComponentUpdateListener updateListener) {
        this.updateListeners.remove(updateListener);
    }

    private void initComponents() {
        this.currencyComboBox = new JComboBox();
        this.currencyLabel = new JLabel();
        this.amountDecimalSpinner = new JSpinner();
        this.amountIntegerSpinner = new JSpinner();
        this.amountLabel = new JLabel();
        this.currencyManageButton = new JButton();
        this.currencyComboBox.setModel(this.currencyComboBoxModel);
        this.currencyLabel.setText("Curreny:");
        this.amountDecimalSpinner.setModel(new SpinnerNumberModel(0, 0, 99, 1));
        this.amountDecimalSpinner.setEditor(new JSpinner.NumberEditor(this.amountDecimalSpinner, "00"));
        this.amountDecimalSpinner.setMinimumSize(new Dimension(40, 28));
        this.amountIntegerSpinner.setModel(new SpinnerNumberModel((Number)0L, null, null, (Number)1L));
        this.amountIntegerSpinner.setMinimumSize(new Dimension(40, 28));
        this.amountLabel.setText("Amount:");
        this.currencyManageButton.setText("Manage");
        this.currencyManageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmountMoneyComponent.this.currencyManageButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.amountLabel).addGap(18, 18, 18).addComponent(this.amountIntegerSpinner, -1, 147, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.amountDecimalSpinner, -1, 151, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.currencyLabel).addGap(18, 18, 18).addComponent(this.currencyComboBox, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.currencyManageButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.currencyComboBox, -2, -1, -2).addComponent(this.currencyLabel).addComponent(this.amountDecimalSpinner, -2, -1, -2).addComponent(this.amountIntegerSpinner, -2, -1, -2).addComponent(this.amountLabel).addComponent(this.currencyManageButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void currencyManageButtonActionPerformed(ActionEvent evt) {
        Set<Currency> storedCurrencies;
        AmountMoneyComponentManageDialog amountMoneyPanelManageDialog;
        try {
            amountMoneyPanelManageDialog = new AmountMoneyComponentManageDialog(this.amountMoneyCurrencyStorage, this.amountMoneyExchangeRateRetriever, this.messageHandler, (Frame)SwingUtilities.getWindowAncestor(this));
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle(new Message(String.format("An exception occured during retrieval of currencies from the storage: %s", ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, "Exception occured"));
            return;
        }
        amountMoneyPanelManageDialog.pack();
        amountMoneyPanelManageDialog.setVisible(true);
        try {
            storedCurrencies = this.amountMoneyCurrencyStorage.getCurrencies();
        }
        catch (AmountMoneyCurrencyStorageException ex) {
            this.messageHandler.handle((Message)new ExceptionMessage((Throwable)ex));
            return;
        }
        Currency selectedCurrency = (Currency)this.currencyComboBoxModel.getSelectedItem();
        for (Currency storedCurrency : storedCurrencies) {
            if (this.comboBoxModelContains(this.currencyComboBoxModel, storedCurrency)) continue;
            this.currencyComboBoxModel.addElement(storedCurrency);
        }
        for (int i = 0; i < this.currencyComboBoxModel.getSize(); ++i) {
            Currency modelCurrency = (Currency)this.currencyComboBoxModel.getElementAt(i);
            if (storedCurrencies.contains(modelCurrency)) continue;
            this.currencyComboBoxModel.removeElement(modelCurrency);
        }
        if (!storedCurrencies.contains(selectedCurrency)) {
            this.currencyComboBoxModel.setSelectedItem(this.currencyComboBoxModel.getElementAt(0));
        } else {
            this.currencyComboBoxModel.setSelectedItem(selectedCurrency);
        }
    }

    private boolean comboBoxModelContains(ComboBoxModel<?> comboBoxModel, Currency currency) {
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!comboBoxModel.getElementAt(i).equals(currency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.currencyManageButton.getBaseline(width, height);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.amountDecimalSpinner.setEnabled(enabled);
        this.amountIntegerSpinner.setEnabled(enabled);
        this.amountLabel.setEnabled(enabled);
        this.currencyComboBox.setEnabled(enabled);
        this.currencyLabel.setEnabled(enabled);
        this.currencyManageButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

