/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.components;

import de.richtercloud.reflection.form.builder.components.NullableComponentUpdateEvent;
import de.richtercloud.reflection.form.builder.components.NullableComponentUpdateListener;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class NullableComponent<T, C extends JComponent>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox checkBox = new JCheckBox("null");
    private final Set<NullableComponentUpdateListener<NullableComponentUpdateEvent<T>>> updateListeners = new HashSet<NullableComponentUpdateListener<NullableComponentUpdateEvent<T>>>();
    private final T initialValue;
    private final C mainComponent;

    public NullableComponent(T initialValue, C mainComponent) {
        this.initialValue = initialValue;
        this.mainComponent = mainComponent;
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)mainComponent, 0, -1, Short.MAX_VALUE).addComponent(this.checkBox));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)mainComponent, 0, -1, Short.MAX_VALUE).addComponent(this.checkBox));
        this.checkBox.addActionListener(e -> {
            mainComponent.setEnabled(!this.checkBox.isSelected());
            this.setValue0(this.getValue0());
            for (NullableComponentUpdateListener<NullableComponentUpdateEvent<T>> updateListener : this.getUpdateListeners()) {
                updateListener.onUpdate(new NullableComponentUpdateEvent<T>(this.getValue()));
            }
        });
        this.reset0();
    }

    public C getMainComponent() {
        return this.mainComponent;
    }

    public void addUpdateListener(NullableComponentUpdateListener<NullableComponentUpdateEvent<T>> updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void removeUpdateListener(NullableComponentUpdateListener<NullableComponentUpdateEvent<T>> updateListener) {
        this.updateListeners.remove(updateListener);
    }

    protected Set<NullableComponentUpdateListener<NullableComponentUpdateEvent<T>>> getUpdateListeners() {
        return Collections.unmodifiableSet(this.updateListeners);
    }

    public T getValue() {
        if (this.checkBox.isSelected()) {
            return null;
        }
        return this.getValue0();
    }

    public void setValue(T value) {
        this.checkBox.setSelected(value == null);
        ((JComponent)this.mainComponent).setEnabled(value != null);
        if (value != null) {
            this.setValue0(value);
        }
        for (NullableComponentUpdateListener<NullableComponentUpdateEvent<T>> updateListener : this.updateListeners) {
            updateListener.onUpdate(new NullableComponentUpdateEvent<T>(value));
        }
    }

    protected abstract void setValue0(T var1);

    protected abstract T getValue0();

    private void reset0() {
        this.setValue(this.initialValue);
    }

    public void reset() {
        this.reset0();
    }
}

