/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder;

import de.richtercloud.reflection.form.builder.ReflectionFormPanelUpdateListener;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ReflectionFormPanel<U extends ReflectionFormPanelUpdateListener>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GroupLayout.Group horizontalSequentialGroup;
    private final GroupLayout.Group verticalSequentialGroup;
    private final Map<Field, JComponent> fieldMapping;
    private final Object instance;
    private final Class<?> entityClass;
    private final Set<U> updateListeners = new HashSet<U>();
    private final FieldHandler fieldHandler;

    public static String generateExceptionMessage(Throwable ex) {
        String retValue = ex.getMessage();
        if (ex.getCause() != null) {
            retValue = String.format("%s (caused by '%s')", retValue, ex.getCause().getMessage());
        }
        return retValue;
    }

    public ReflectionFormPanel(Map<Field, JComponent> fieldMapping, Object instance, Class<?> entityClass, FieldHandler fieldHandler) {
        this.initComponents();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.horizontalSequentialGroup = layout.createSequentialGroup();
        this.verticalSequentialGroup = layout.createSequentialGroup();
        layout.setHorizontalGroup(this.horizontalSequentialGroup);
        layout.setVerticalGroup(this.verticalSequentialGroup);
        if (instance == null) {
            throw new IllegalArgumentException("instance mustn't be null");
        }
        if (fieldMapping == null) {
            throw new IllegalArgumentException("fieldMapping mustn't be null");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass mustn't be null");
        }
        this.fieldMapping = fieldMapping;
        this.instance = instance;
        this.entityClass = entityClass;
        this.fieldHandler = fieldHandler;
    }

    public void addUpdateListener(U updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void removeUpdateListener(U updateListener) {
        this.updateListeners.remove(updateListener);
    }

    protected Set<U> getUpdateListeners() {
        return Collections.unmodifiableSet(this.updateListeners);
    }

    @Override
    public GroupLayout getLayout() {
        return (GroupLayout)super.getLayout();
    }

    public GroupLayout.Group getVerticalMainGroup() {
        return this.verticalSequentialGroup;
    }

    public GroupLayout.Group getHorizontalMainGroup() {
        return this.horizontalSequentialGroup;
    }

    public JComponent getComponentByField(Field field) {
        return this.fieldMapping.get(field);
    }

    public Object retrieveInstance() {
        return this.instance;
    }

    public Map<Field, JComponent> getFieldMapping() {
        return Collections.unmodifiableMap(this.fieldMapping);
    }

    public FieldHandler getFieldHandler() {
        return this.fieldHandler;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void reset() throws ResetException {
        for (Component component : this.getFieldMapping().values()) {
            this.getFieldHandler().reset(component);
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

