/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ReflectionFormFieldLabel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WIDTH_DEFAULT = 50;

    public ReflectionFormFieldLabel(String fieldName, String fieldDescription, String fieldDescriptionDialogTitle) {
        this(fieldName, fieldDescription, fieldDescriptionDialogTitle, 50);
    }

    public ReflectionFormFieldLabel(String fieldName, final String fieldDescription, final String fieldDescriptionDialogTitle, int labelMaxWidth) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName mustn't be null");
        }
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("fieldName mustn't be empty");
        }
        if (fieldDescription == null) {
            throw new IllegalArgumentException("fieldDescription mustn't be null");
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JLabel fieldNameLabel = new JLabel(String.format("<html>%s</html>", fieldName));
        GroupLayout.SequentialGroup layoutHorizontalGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup layoutVerticalGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        ((GroupLayout.Group)layoutHorizontalGroup).addComponent(fieldNameLabel, -1, labelMaxWidth, -2);
        ((GroupLayout.Group)layoutVerticalGroup).addComponent(fieldNameLabel);
        if (!fieldDescription.isEmpty()) {
            fieldNameLabel.setToolTipText(fieldDescription);
            JButton fieldDescriptionButton = new JButton("?");
            fieldDescriptionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showConfirmDialog(ReflectionFormFieldLabel.this, fieldDescription, fieldDescriptionDialogTitle, -1, 1);
                }
            });
            ((GroupLayout.Group)layoutHorizontalGroup).addGap(8);
            ((GroupLayout.Group)layoutHorizontalGroup).addComponent(fieldDescriptionButton);
            ((GroupLayout.Group)layoutVerticalGroup).addComponent(fieldDescriptionButton);
        }
        layout.setHorizontalGroup(layoutHorizontalGroup);
        layout.setVerticalGroup(layoutVerticalGroup);
    }
}

