/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder;

import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.reflection.form.builder.FieldInfo;
import de.richtercloud.reflection.form.builder.FieldUpdateException;
import de.richtercloud.reflection.form.builder.ReflectionFormFieldLabel;
import de.richtercloud.reflection.form.builder.ReflectionFormPanel;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.TransformationException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.validation.tools.FieldRetriever;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionFormBuilder<F extends FieldRetriever> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionFormBuilder.class);
    private static final int LABEL_WIDTH_MIN = 150;
    private final String fieldDescriptionDialogTitle;
    private final IssueHandler issueHandler;
    private final F fieldRetriever;

    public static void validateMapping(Map<?, ?> mapping, String argumentName) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("%s mustn't be null", argumentName));
        }
        if (mapping.values().contains(null)) {
            throw new IllegalArgumentException(String.format("%s mustn't contain null values", argumentName));
        }
    }

    public ReflectionFormBuilder(String fieldDescriptionDialogTitle, IssueHandler issueHandler, F fieldRetriever) {
        if (issueHandler == null) {
            throw new IllegalArgumentException("messageHandler mustn't be null");
        }
        this.fieldDescriptionDialogTitle = fieldDescriptionDialogTitle;
        this.issueHandler = issueHandler;
        this.fieldRetriever = fieldRetriever;
    }

    public IssueHandler getIssueHandler() {
        return this.issueHandler;
    }

    protected F getFieldRetriever() {
        return this.fieldRetriever;
    }

    protected JComponent getClassComponent(Field field, Class<?> entityClass, Object instance, FieldHandler fieldHandler) throws FieldHandlingException, ResetException {
        if (!field.getDeclaringClass().isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException(String.format("field %s has to be declared by entityClass", field));
        }
        field.setAccessible(true);
        JComponent retValue = fieldHandler.handle(field, instance, event -> {
            try {
                this.onFieldUpdate(event, field, instance);
            }
            catch (FieldUpdateException ex) {
                LOGGER.error("unexpected exception during field update occured", (Throwable)ex);
                this.issueHandler.handleUnexpectedException(new ExceptionMessage((Throwable)ex));
            }
        }, this);
        return retValue;
    }

    protected void onFieldUpdate(FieldUpdateEvent event, Field field, Object instance) throws FieldUpdateException {
        Object eventNewValue = event.getNewValue();
        try {
            field.set(instance, eventNewValue);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldUpdateException(ex);
        }
    }

    protected void transformClass(Class<?> clazz, Object instance, Map<Field, JComponent> fieldMapping, ReflectionFormPanel reflectionFormPanel, FieldHandler fieldHandler) throws TransformationException, ResetException {
        List clazzFields = this.fieldRetriever.retrieveRelevantFields(clazz);
        LOGGER.trace(String.format("relevant fields for class %s are %s", clazz.getName(), clazzFields));
        GroupLayout layout = reflectionFormPanel.getLayout();
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.ParallelGroup horizontalLabelParallelGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup horizontalCompParallelGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (Field field : clazzFields) {
            String fieldDescription;
            String fieldName;
            JComponent comp;
            try {
                comp = this.getClassComponent(field, clazz, instance, fieldHandler);
            }
            catch (FieldHandlingException ex) {
                throw new TransformationException(ex);
            }
            FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
            if (fieldInfo != null) {
                fieldName = String.format("%s (%s)", fieldInfo.name(), field.getName());
                fieldDescription = fieldInfo.description();
            } else {
                fieldName = field.getName();
                fieldDescription = "";
            }
            ReflectionFormFieldLabel label = new ReflectionFormFieldLabel(fieldName, fieldDescription, this.fieldDescriptionDialogTitle);
            ((GroupLayout.Group)horizontalLabelParallelGroup).addComponent(label, (int)(label.getMinimumSize().getWidth() < 150.0 ? label.getMinimumSize().getWidth() : 150.0), -2, -2);
            ((GroupLayout.Group)horizontalCompParallelGroup).addComponent(comp, 0, (int)comp.getMinimumSize().getWidth(), Short.MAX_VALUE);
            GroupLayout.ParallelGroup verticalFieldGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            ((GroupLayout.Group)verticalFieldGroup).addComponent(label);
            ((GroupLayout.Group)verticalFieldGroup).addComponent(comp);
            reflectionFormPanel.getVerticalMainGroup().addGroup(verticalFieldGroup);
            fieldMapping.put(field, comp);
        }
        reflectionFormPanel.getHorizontalMainGroup().addGroup(horizontalLabelParallelGroup).addGroup(horizontalCompParallelGroup);
    }

    public ReflectionFormPanel transformEntityClass(Class<?> entityClass, Object entityToUpdate, FieldHandler fieldHandler) throws TransformationException, ResetException {
        HashMap<Field, JComponent> fieldMapping = new HashMap<Field, JComponent>();
        Object instance = this.prepareInstance(entityClass, entityToUpdate);
        ReflectionFormPanel retValue = new ReflectionFormPanel(fieldMapping, instance, entityClass, fieldHandler);
        this.transformClass(entityClass, instance, fieldMapping, retValue, fieldHandler);
        return retValue;
    }

    protected Object prepareInstance(Class<?> entityClass, Object entityToUpdate) throws TransformationException {
        Object retValue = entityToUpdate;
        if (retValue == null) {
            Constructor<?> entityClassConstructor = null;
            try {
                entityClassConstructor = entityClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException(String.format("entityClass %s doesn't provide a zero-argument-constructor (see nested exception for details)", entityClass), ex);
            }
            entityClassConstructor.setAccessible(true);
            try {
                retValue = entityClassConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new TransformationException(ex);
            }
        }
        return retValue;
    }
}

