/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.message.handler;

import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.JavaFXDialogBugHandler;
import de.richtercloud.message.handler.JavaFXDialogMessageHandler;
import de.richtercloud.message.handler.Message;
import javafx.scene.control.Alert;

public class JavaFXDialogIssueHandler
implements IssueHandler {
    private final JavaFXDialogMessageHandler messageHandler;
    private final JavaFXDialogBugHandler bugHandler;

    protected static Alert.AlertType translateType(int messageType) {
        switch (messageType) {
            case 0: {
                return Alert.AlertType.ERROR;
            }
            case 2: {
                return Alert.AlertType.WARNING;
            }
            case 1: {
                return Alert.AlertType.INFORMATION;
            }
            case -1: {
                return Alert.AlertType.NONE;
            }
            case 3: {
                return Alert.AlertType.CONFIRMATION;
            }
        }
        throw new IllegalArgumentException(String.format("messageType %d not supported", messageType));
    }

    public JavaFXDialogIssueHandler(JavaFXDialogMessageHandler messageHandler, JavaFXDialogBugHandler bugHandler) {
        this.messageHandler = messageHandler;
        this.bugHandler = bugHandler;
    }

    public JavaFXDialogIssueHandler() {
        this.messageHandler = new JavaFXDialogMessageHandler();
        this.bugHandler = new JavaFXDialogBugHandler();
    }

    @Override
    public void handle(Message message) {
        this.messageHandler.handle(message);
    }

    @Override
    public void handleUnexpectedException(ExceptionMessage message) {
        this.bugHandler.handleUnexpectedException(message);
    }

    @Override
    public void shutdown() {
        this.bugHandler.shutdown();
    }
}

