/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.message.handler;

import de.richtercloud.message.handler.DisplayCallable;
import de.richtercloud.message.handler.EDTExectutionException;
import java.lang.reflect.InvocationTargetException;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisplayUtils.class);
    private static final Object JAVA_FX_RESULT_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T displayOnJavaFXThread(DisplayCallable<T> callable) {
        if (Platform.isFxApplicationThread()) {
            return callable.call();
        }
        EDTAnswer retValueHelper = new EDTAnswer();
        Platform.runLater(() -> {
            retValueHelper.setValue(callable.call());
            Object object = JAVA_FX_RESULT_LOCK;
            synchronized (object) {
                JAVA_FX_RESULT_LOCK.notifyAll();
            }
        });
        try {
            Object object = JAVA_FX_RESULT_LOCK;
            synchronized (object) {
                JAVA_FX_RESULT_LOCK.wait();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.error("unexpected exception during processing of callable on JavaFX application thread", (Throwable)ex);
            throw new EDTExectutionException(ex);
        }
        return retValueHelper.getValue();
    }

    public static <T> T displayOnEDT(DisplayCallable<T> callable) {
        if (SwingUtilities.isEventDispatchThread()) {
            return callable.call();
        }
        EDTAnswer retValueHelper = new EDTAnswer();
        try {
            SwingUtilities.invokeAndWait(() -> retValueHelper.setValue(callable.call()));
        }
        catch (InterruptedException | InvocationTargetException ex) {
            LOGGER.error("unexpected exception during processing of callable on EDT", (Throwable)ex);
            throw new EDTExectutionException(ex);
        }
        return retValueHelper.getValue();
    }

    private DisplayUtils() {
    }

    private static class EDTAnswer<T> {
        private T value;

        protected EDTAnswer() {
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

