/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.message.handler;

import de.richtercloud.message.handler.DialogBugHandler;
import de.richtercloud.message.handler.DialogMessageHandler;
import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.Message;
import java.awt.Frame;

public class DialogIssueHandler
implements IssueHandler {
    private final DialogMessageHandler messageHandler;
    private final DialogBugHandler bugHandler;

    public DialogIssueHandler(DialogMessageHandler messageHandler, DialogBugHandler bugHandler) {
        this.messageHandler = messageHandler;
        this.bugHandler = bugHandler;
    }

    public DialogIssueHandler(Frame parent, String bugReportingURL) {
        this.messageHandler = new DialogMessageHandler(parent);
        this.bugHandler = new DialogBugHandler(parent, bugReportingURL);
    }

    public DialogIssueHandler(Frame parent, String bugReportingURL, int textWidth) {
        this.messageHandler = new DialogMessageHandler(parent, textWidth);
        this.bugHandler = new DialogBugHandler(parent, bugReportingURL, textWidth);
    }

    public DialogIssueHandler(Frame parent, String bugReportingURL, String titlePrefix, String titleSuffix) {
        this.messageHandler = new DialogMessageHandler(parent, titlePrefix, titleSuffix);
        this.bugHandler = new DialogBugHandler(parent, bugReportingURL, titlePrefix, titleSuffix);
    }

    public DialogIssueHandler(Frame parent, String bugReportingURL, int textWidth, String titlePrefix, String titleSuffix) {
        this.messageHandler = new DialogMessageHandler(parent, textWidth, titlePrefix, titleSuffix);
        this.bugHandler = new DialogBugHandler(parent, bugReportingURL, textWidth, titlePrefix, titleSuffix);
    }

    @Override
    public void handle(Message message) {
        this.messageHandler.handle(message);
    }

    @Override
    public void handleUnexpectedException(ExceptionMessage message) {
        this.bugHandler.handleUnexpectedException(message);
    }

    @Override
    public void shutdown() {
        this.bugHandler.shutdown();
    }
}

