/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.message.handler;

import de.richtercloud.message.handler.BugHandler;
import de.richtercloud.message.handler.DefaultDialogDisplayer;
import de.richtercloud.message.handler.DialogDisplayer;
import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.Message;
import java.awt.Window;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DialogBugHandler
implements BugHandler {
    private final String bugReportingURL;
    private final DialogDisplayer dialogDisplayer;

    public DialogBugHandler(Window parent, String bugReportingURL, int textWidth, String titlePrefix, String titleSuffix) {
        this.dialogDisplayer = new DefaultDialogDisplayer(parent, textWidth, titlePrefix, titleSuffix);
        this.bugReportingURL = bugReportingURL;
    }

    public DialogBugHandler(Window parent, String bugReportingURL, String titlePrefix, String titleSuffix) {
        this(parent, bugReportingURL, 200, titlePrefix, titleSuffix);
    }

    public DialogBugHandler(Window parent, String bugReportingURL) {
        this(parent, bugReportingURL, 200, "", "");
    }

    public DialogBugHandler(Window parent, String bugReportingURL, int textWidth) {
        this(parent, bugReportingURL, textWidth, "", "");
    }

    @Override
    public void handleUnexpectedException(ExceptionMessage message) {
        String message0 = String.format("The following exception occured: %s.\nPlease consider filing a bug at <a href=\"%s\">%s</a>.\nStacktrace: %s", message.getText(), this.bugReportingURL, this.bugReportingURL, ExceptionUtils.getStackTrace((Throwable)message.getThrowable()));
        this.dialogDisplayer.displayDialog(new Message(message0, message.getType(), message.getSummary()));
    }

    @Override
    public void shutdown() {
    }
}

