/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.message.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Message {
    public static final Set<Integer> ALLOWED_TYPES = new HashSet<Integer>(Arrays.asList(0, 1, -1, 2, 3));
    private final String text;
    private final int type;
    private final String summary;

    public Message(String text, int type, String summary) {
        if (!ALLOWED_TYPES.contains(type)) {
            throw new IllegalArgumentException(String.format("type has to be one of '%s'", ALLOWED_TYPES));
        }
        this.text = text;
        this.type = type;
        this.summary = summary;
    }

    public Message(Throwable throwable, int type) {
        this(ExceptionUtils.getRootCauseMessage((Throwable)throwable), type, throwable.getClass().getSimpleName());
    }

    public Message(Throwable throwable) {
        this(ExceptionUtils.getRootCauseMessage((Throwable)throwable), 0, throwable.getClass().getSimpleName());
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getSummary() {
        return this.summary;
    }
}

