/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.message.handler;

import de.richtercloud.message.handler.ConfirmOption;
import de.richtercloud.message.handler.DialogDisplayer;
import de.richtercloud.message.handler.DisplayUtils;
import de.richtercloud.message.handler.Message;
import java.awt.Window;
import javax.swing.JOptionPane;

public class DefaultDialogDisplayer
implements DialogDisplayer {
    private static final String MESSAGE_NULL_MESSAGE = "message mustn't be null";
    private final Window parent;
    private final int textWidth;
    private final String titlePrefix;
    private final String titleSuffix;

    public DefaultDialogDisplayer(Window parent, int textWidth, String titlePrefix, String titleSuffix) {
        this.parent = parent;
        this.textWidth = textWidth;
        this.titlePrefix = titlePrefix;
        this.titleSuffix = titleSuffix;
    }

    @Override
    public void displayDialog(Message message) {
        if (message == null) {
            throw new IllegalArgumentException(MESSAGE_NULL_MESSAGE);
        }
        DisplayUtils.displayOnEDT(() -> {
            JOptionPane.showMessageDialog(this.parent, this.formatMessage(message.getText(), this.textWidth), this.generateDialogTitle(message.getSummary()), message.getType());
            return null;
        });
    }

    @Override
    public String displayDialog(Message message, String ... options) {
        if (message == null) {
            throw new IllegalArgumentException(MESSAGE_NULL_MESSAGE);
        }
        if (options == null) {
            throw new IllegalArgumentException("optionLabelMap mustn'be null");
        }
        if (options.length == 0) {
            throw new IllegalArgumentException("optionLabelMap mustn't be empty");
        }
        return DisplayUtils.displayOnEDT(() -> (String)JOptionPane.showInputDialog(this.parent, this.formatMessage(message.getText(), this.textWidth), this.generateDialogTitle(message.getSummary()), message.getType(), null, options, options[0]));
    }

    public ConfirmOption displayDialog(Message message, ConfirmOption ... options) {
        if (message == null) {
            throw new IllegalArgumentException(MESSAGE_NULL_MESSAGE);
        }
        if (options == null) {
            throw new IllegalArgumentException("optionLabelMap mustn'be null");
        }
        if (options.length == 0) {
            throw new IllegalArgumentException("optionLabelMap mustn't be empty");
        }
        return DisplayUtils.displayOnEDT(() -> (ConfirmOption)JOptionPane.showInputDialog(this.parent, this.formatMessage(message.getText(), this.textWidth), this.generateDialogTitle(message.getSummary()), message.getType(), null, options, options[0]));
    }

    @Override
    public int displayYesNoDialog(Message message) {
        if (message == null) {
            throw new IllegalArgumentException(MESSAGE_NULL_MESSAGE);
        }
        return DisplayUtils.displayOnEDT(() -> JOptionPane.showConfirmDialog(this.parent, this.formatMessage(message.getText(), this.textWidth), this.generateDialogTitle(message.getSummary()), 0, message.getType()));
    }

    private String formatMessage(String message, int textWidth) {
        return String.format("<html><body width='%d'>%s</body></html>", textWidth, message);
    }

    private String generateDialogTitle(String messageSummary, String titlePrefix, String titleSuffix) {
        return String.format("%s%s%s", titlePrefix, messageSummary, titleSuffix);
    }

    private String generateDialogTitle(String messageSummary) {
        return this.generateDialogTitle(messageSummary, this.titlePrefix, this.titleSuffix);
    }
}

