/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package de.richtercloud.jhbuild.java.wrapper;

import java.io.IOException;
import java.nio.file.Path;

/**
 * Introduced after experiencing trouble copying {@code /etc/ssl/certs/NetLock_Arany_\=Class_Gold\=_Főtanúsítvány.pem}
 * which failed due to
 * {@code  java.io.FileNotFoundException: /etc/ssl/certs/NetLock_Arany_=Class_Gold=_F??tan??s??tv??ny.pem (No such file or directory)}
 *
 * @author richter
 */
public final class FileUtils {

    private FileUtils() {
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory(src.toFile(), dest.toFile());
    }
}
