/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.preview;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.drag.effects.DefaultPreview;
import org.flexdock.util.SwingUtility;

public class GhostPreview
extends DefaultPreview {
    private static final String PREVIOUS_BOUNDS = "TestPreview.PREVIOUS_BOUNDS";
    private static final String PREVIEW_IMG = "TestPreview.PREVIEW_IMG";

    public Polygon createPreviewPolygon(Component dockable, DockingPort port, Dockable hover, String targetRegion, Component paintingTarget, Map dragInfo) {
        Polygon polygon = super.createPreviewPolygon(dockable, port, hover, targetRegion, paintingTarget, dragInfo);
        if (polygon == null) {
            return null;
        }
        Rectangle prevBounds = (Rectangle)dragInfo.get(PREVIOUS_BOUNDS);
        Rectangle bounds = polygon.getBounds();
        if (!bounds.equals(prevBounds)) {
            Dimension origSize = dockable.getSize();
            dockable.setSize(bounds.getSize());
            BufferedImage img = SwingUtility.createImage((Component)dockable);
            dragInfo.put(PREVIEW_IMG, img);
            dockable.setSize(origSize);
        }
        dragInfo.put(PREVIOUS_BOUNDS, bounds);
        return polygon;
    }

    public void drawPreview(Graphics2D g, Polygon poly, Dockable dockable, Map dragInfo) {
        BufferedImage image = (BufferedImage)dragInfo.get(PREVIEW_IMG);
        if (image == null) {
            return;
        }
        Rectangle bounds = poly.getBounds();
        g.setColor(Color.BLACK);
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.5f);
        g.setComposite(composite);
        g.drawImage((Image)image, bounds.x, bounds.y, null);
    }

    protected Rectangle createTabbedPaneRect(DockingPort port, Component hover) {
        if (hover != null) {
            return hover.getBounds();
        }
        return super.createTabbedPaneRect(port, hover);
    }
}

