/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class RootWindow {
    public static final Integer DEFAULT_MAXED_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 10);
    private static final Map MAP_BY_ROOT_CONTAINER = new WeakHashMap();
    private LayoutManager maxedLayout;
    private Integer maximizationLayer;
    private WeakReference root;
    private HashMap clientProperties;

    private static Component getRoot(Component c) {
        Container parent;
        if (c == null) {
            return null;
        }
        if (RootWindow.isValidRootContainer(c)) {
            return c;
        }
        for (parent = c.getParent(); parent != null && !RootWindow.isValidRootContainer(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public static RootWindow getRootContainer(Component c) {
        Component root = RootWindow.getRoot(c);
        if (!RootWindow.isValidRootContainer(root)) {
            return null;
        }
        RootWindow container = (RootWindow)MAP_BY_ROOT_CONTAINER.get(root);
        if (container == null) {
            container = new RootWindow(root);
            MAP_BY_ROOT_CONTAINER.put(root, container);
        }
        if (container.getRootContainer() != root) {
            container.setRootContainer(root);
        }
        return container;
    }

    public static boolean isValidRootContainer(Component c) {
        return c != null && (c instanceof JFrame || c instanceof JApplet || c instanceof JWindow || c instanceof JDialog);
    }

    public static RootWindow[] getVisibleWindows() {
        Frame[] frames = Frame.getFrames();
        HashSet cache = new HashSet(frames.length);
        for (int i = 0; i < frames.length; ++i) {
            RootWindow.populateWindowList(new RootWindow(frames[i]), cache, true);
        }
        return cache.toArray(new RootWindow[0]);
    }

    private static void populateWindowList(RootWindow win, HashSet winCache, boolean visOnly) {
        if (win == null || winCache.contains(win)) {
            return;
        }
        if (visOnly && !win.getRootContainer().isVisible()) {
            return;
        }
        winCache.add(win);
        Window[] children = win.getOwnedWindows();
        for (int i = 0; i < children.length; ++i) {
            RootWindow.populateWindowList(new RootWindow(children[i]), winCache, visOnly);
        }
    }

    protected RootWindow(Component root) {
        this.setMaximizationLayer(DEFAULT_MAXED_LAYER);
        this.setRootContainer(root);
        this.clientProperties = new HashMap();
    }

    public Container getContentPane() {
        Container c = null;
        if (this.getRootContainer() instanceof RootPaneContainer) {
            c = ((RootPaneContainer)((Object)this.getRootContainer())).getContentPane();
        }
        return c;
    }

    public Component getGlassPane() {
        Component c = null;
        if (this.getRootContainer() instanceof RootPaneContainer) {
            c = ((RootPaneContainer)((Object)this.getRootContainer())).getGlassPane();
        }
        return c;
    }

    public JLayeredPane getLayeredPane() {
        JLayeredPane pane = null;
        if (this.getRootContainer() instanceof RootPaneContainer) {
            pane = ((RootPaneContainer)((Object)this.getRootContainer())).getLayeredPane();
        }
        return pane;
    }

    public Point getLocationOnScreen() {
        return this.getRootContainer().getLocationOnScreen();
    }

    public Integer getMaximizationLayer() {
        return this.maximizationLayer;
    }

    public LayoutManager getMaximizedLayout() {
        return this.maxedLayout;
    }

    public Component getRootContainer() {
        return (Component)this.root.get();
    }

    public JRootPane getRootPane() {
        JRootPane pane = null;
        if (this.getRootContainer() instanceof RootPaneContainer) {
            pane = ((RootPaneContainer)((Object)this.getRootContainer())).getRootPane();
        }
        return pane;
    }

    public void revalidateContentPane() {
        Container c = this.getContentPane();
        if (c instanceof JComponent) {
            c.revalidate();
        }
    }

    public void setContentPane(Container contentPane) {
        if (this.getRootContainer() instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.getRootContainer())).setContentPane(contentPane);
        }
    }

    public void setGlassPane(Component glassPane) {
        if (this.getRootContainer() instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.getRootContainer())).setGlassPane(glassPane);
        }
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        if (this.getRootContainer() instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.getRootContainer())).setLayeredPane(layeredPane);
        }
    }

    public Window[] getOwnedWindows() {
        if (this.getRootContainer() instanceof JFrame) {
            return ((Window)this.getRootContainer()).getOwnedWindows();
        }
        if (this.getRootContainer() instanceof JWindow) {
            return ((Window)this.getRootContainer()).getOwnedWindows();
        }
        if (this.getRootContainer() instanceof JDialog) {
            return ((Window)this.getRootContainer()).getOwnedWindows();
        }
        return new Window[0];
    }

    public void setMaximizationLayer(Integer layer) {
        if (layer == null) {
            layer = DEFAULT_MAXED_LAYER;
        }
        this.maximizationLayer = layer;
    }

    public void setMaximizedLayout(LayoutManager mgr) {
        this.maxedLayout = mgr;
    }

    protected void setRootContainer(Component root) {
        this.root = new WeakReference<Component>(root);
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this.getRootContainer());
        this.pack();
    }

    public void pack() {
        Component root = this.getRootContainer();
        if (root instanceof JFrame) {
            ((Window)root).pack();
        } else if (root instanceof JWindow) {
            ((Window)root).pack();
        } else if (root instanceof JDialog) {
            ((Window)root).pack();
        }
    }

    public void toFront() {
        Component root = this.getRootContainer();
        if (root instanceof JFrame) {
            ((Window)root).toFront();
        } else if (root instanceof JWindow) {
            ((Window)root).toFront();
        } else if (root instanceof JDialog) {
            ((Window)root).toFront();
        }
    }

    public boolean isActive() {
        Component root = this.getRootContainer();
        if (root instanceof JFrame) {
            return ((Window)root).isActive();
        }
        if (root instanceof JWindow) {
            return ((Window)root).isActive();
        }
        if (root instanceof JDialog) {
            return ((Window)root).isActive();
        }
        return false;
    }

    public Window getOwner() {
        Component root = this.getRootContainer();
        if (root instanceof JFrame) {
            return ((Window)root).getOwner();
        }
        if (root instanceof JWindow) {
            return ((Window)root).getOwner();
        }
        if (root instanceof JDialog) {
            return ((Window)root).getOwner();
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.getRootContainer().getBounds();
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.clientProperties.remove(key);
        } else {
            this.clientProperties.put(key, value);
        }
    }

    public Object getClientProperty(Object key) {
        return key == null ? null : this.clientProperties.get(key);
    }
}

