/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.state.tree;

import java.awt.Component;
import javax.swing.JSplitPane;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.tree.DockingNode;
import org.flexdock.docking.state.tree.DockingPortNode;

public class SplitNode
extends DockingNode
implements DockingConstants {
    private int orientation;
    private int region;
    private float percentage;
    private String siblingId;
    private String dockingRegion;

    public SplitNode(int orientation, int region, float percentage, String siblingId) {
        this.orientation = orientation;
        this.region = region;
        this.percentage = percentage;
        this.siblingId = siblingId;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

    public int getRegion() {
        return this.region;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public String getSiblingId() {
        return this.siblingId;
    }

    public void setSiblingId(String siblingId) {
        this.siblingId = siblingId;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("SplitNode[");
        sb.append("orient=").append(this.getOrientationDesc()).append("; ");
        sb.append("region=").append(this.getRegionDesc()).append("; ");
        sb.append("percent=").append(this.percentage).append("%;");
        sb.append("]");
        return sb.toString();
    }

    public String getRegionDesc() {
        switch (this.region) {
            case 1: {
                return "top";
            }
            case 3: {
                return "bottom";
            }
            case 4: {
                return "right";
            }
        }
        return "left";
    }

    public String getOrientationDesc() {
        return this.orientation == 0 ? "vertical" : "horizontal";
    }

    @Override
    public Object clone() {
        return new SplitNode(this.orientation, this.region, this.percentage, this.siblingId);
    }

    public String getDockingRegion() {
        return this.dockingRegion;
    }

    public void setDockingRegion(String dockingRegion) {
        this.dockingRegion = dockingRegion;
    }

    @Override
    public Object getDockingObject() {
        if (this.dockingRegion == null) {
            return null;
        }
        if (!(this.getParent() instanceof DockingPortNode)) {
            return null;
        }
        DockingPortNode superNode = (DockingPortNode)this.getParent();
        Object userObj = superNode.getUserObject();
        if (!(userObj instanceof DockingPort)) {
            return null;
        }
        DockingPort superPort = (DockingPort)userObj;
        DockingStrategy strategy = superPort.getDockingStrategy();
        return strategy.createSplitPane(superPort, this.dockingRegion, this.percentage);
    }

    public JSplitPane getSplitPane() {
        return (JSplitPane)this.getUserObject();
    }

    public Component getLeftComponent() {
        return this.getChildComponent(0);
    }

    public Component getRightComponent() {
        return this.getChildComponent(1);
    }

    private Component getChildComponent(int indx) {
        LayoutNode child = this.getChild(indx);
        return child == null ? null : (Component)child.getUserObject();
    }

    private LayoutNode getChild(int indx) {
        if (indx >= this.getChildCount()) {
            return null;
        }
        return (LayoutNode)this.getChildAt(indx);
    }

    @Override
    protected DockingNode shallowClone() {
        SplitNode clone = new SplitNode(this.orientation, this.region, this.percentage, this.siblingId);
        clone.dockingRegion = this.dockingRegion;
        return clone;
    }
}

