/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.state;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.flexdock.docking.floating.frames.DockingFrame;

public class FloatingGroup
implements Cloneable,
Serializable {
    private String name;
    private Rectangle windowBounds;
    private transient DockingFrame frame;
    private HashSet dockables;

    public FloatingGroup(String groupName) {
        this.name = groupName == null ? UUID.randomUUID().toString() : groupName;
        this.dockables = new HashSet();
    }

    private FloatingGroup(String groupName, HashSet dockableSet) {
        this.name = groupName;
        this.dockables = dockableSet;
    }

    public Rectangle getBounds() {
        return this.windowBounds == null ? null : (Rectangle)this.windowBounds.clone();
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            this.windowBounds = null;
        } else if (this.windowBounds == null) {
            this.windowBounds = (Rectangle)rect.clone();
        } else {
            this.windowBounds.setBounds(rect);
        }
    }

    public String getName() {
        return this.name;
    }

    public DockingFrame getFrame() {
        return this.frame;
    }

    public void setFrame(DockingFrame frame) {
        this.frame = frame;
    }

    public void addDockable(String dockableId) {
        this.dockables.add(dockableId);
    }

    public Iterator getDockableIterator() {
        return this.dockables.iterator();
    }

    public void removeDockable(String dockableId) {
        this.dockables.remove(dockableId);
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public void destroy() {
        this.dockables.clear();
        this.setFrame(null);
        this.setBounds(null);
    }

    public Object clone() {
        HashSet set = (HashSet)this.dockables.clone();
        FloatingGroup clone = new FloatingGroup(this.name, set);
        clone.frame = this.frame;
        clone.windowBounds = (Rectangle)this.windowBounds.clone();
        return clone;
    }
}

