/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.state;

import java.awt.Point;
import java.io.Serializable;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.state.DockingPath;

public class DockingState
implements Cloneable,
Serializable,
DockingConstants {
    private String dockableId;
    private String relativeParentId;
    private String region = "UNKNOWN";
    private float splitRatio = -1.0f;
    private String floatingGroup;
    private int minimizedConstraint = -1;
    private DockingPath dockingPath;
    private int centerX = -1;
    private int centerY = -1;

    public DockingState(String dockableId) {
        this.dockableId = dockableId;
    }

    public Dockable getDockable() {
        return DockingManager.getDockable(this.dockableId);
    }

    public String getDockableId() {
        return this.dockableId;
    }

    public float getSplitRatio() {
        return this.splitRatio;
    }

    public void setSplitRatio(float ratio) {
        this.splitRatio = ratio;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getMinimizedConstraint() {
        return this.minimizedConstraint;
    }

    public String getFloatingGroup() {
        return this.floatingGroup;
    }

    public boolean isFloating() {
        return this.floatingGroup != null;
    }

    public boolean isMinimized() {
        return this.minimizedConstraint != -1;
    }

    public boolean hasDockingPath() {
        return this.dockingPath != null;
    }

    public DockingPath getPath() {
        return this.dockingPath;
    }

    public void setPath(DockingPath path) {
        this.dockingPath = path;
    }

    public void setMinimizedConstraint(int constraint) {
        this.minimizedConstraint = constraint;
        if (constraint != -1) {
            this.floatingGroup = null;
        }
    }

    public void setFloatingGroup(String group) {
        this.floatingGroup = group;
        if (group != null) {
            this.minimizedConstraint = -1;
        }
    }

    public Dockable getRelativeParent() {
        return DockingManager.getDockable(this.relativeParentId);
    }

    public String getRelativeParentId() {
        return this.relativeParentId;
    }

    public void setRelativeParent(Dockable parent) {
        String parentId = parent == null ? null : parent.getPersistentId();
        this.setRelativeParentId(parentId);
    }

    public void setRelativeParentId(String relativeParentId) {
        this.relativeParentId = relativeParentId;
    }

    public String toString() {
        return "DockingState[id=" + this.dockableId + "; center=[" + this.centerX + "%," + this.centerY + "%]; parent=" + this.relativeParentId + "; region=" + this.region + "; ratio=" + this.splitRatio + "; float=" + this.floatingGroup + "; minimization=" + this.minimizedConstraint + "; ]";
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public void setCenter(Point p) {
        this.centerX = p == null ? 0 : p.x;
        this.centerY = p == null ? 0 : p.y;
    }

    public Point getCenterPoint() {
        if (this.centerX == -1 || this.centerY == -1) {
            return null;
        }
        return new Point(this.centerX, this.centerY);
    }

    public boolean hasCenterPoint() {
        return this.centerX != -1 && this.centerY != -1;
    }

    public Object clone() {
        DockingState dockingStateClone = new DockingState(this.dockableId);
        dockingStateClone.relativeParentId = this.relativeParentId;
        dockingStateClone.region = this.region;
        dockingStateClone.splitRatio = this.splitRatio;
        dockingStateClone.floatingGroup = this.floatingGroup;
        dockingStateClone.minimizedConstraint = this.minimizedConstraint;
        dockingStateClone.dockingPath = this.dockingPath == null ? null : (DockingPath)this.dockingPath.clone();
        dockingStateClone.centerX = this.centerX;
        dockingStateClone.centerY = this.centerY;
        return dockingStateClone;
    }
}

