/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.state;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DockingSplitPane;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.SwingUtility;

public class DockingPath
implements Cloneable,
DockingConstants,
Serializable {
    public static final String RESTORE_PATH_KEY = "DockingPath.RESTORE_PATH_KEY";
    private transient String stringForm;
    private String rootPortId;
    private ArrayList nodes;
    private String siblingId;
    private boolean tabbed;

    public DockingPath() {
        this.nodes = new ArrayList();
    }

    public static DockingPath create(String dockableId) {
        Dockable dockable = DockingPath.findDockable(dockableId);
        return DockingPath.create(dockable);
    }

    public static DockingPath create(Dockable dockable) {
        if (dockable == null || !DockingPath.isDocked(dockable)) {
            return null;
        }
        DockingPath path = new DockingPath(dockable);
        Component comp = dockable.getComponent();
        Container parent = comp.getParent();
        while (!DockingPath.isDockingRoot(parent)) {
            if (parent instanceof DockingPort) {
                SplitNode node = DockingPath.createNode((DockingPort)((Object)parent));
                path.addNode(node);
            }
            parent = parent.getParent();
        }
        if (DockingPath.isDockingRoot(parent)) {
            path.setRootPortId(((DockingPort)((Object)parent)).getPersistentId());
        }
        path.initialize();
        return path;
    }

    public static SplitNode createNode(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Container parent = dockable.getComponent().getParent();
        return parent instanceof DockingPort ? DockingPath.createNode((DockingPort)((Object)parent)) : null;
    }

    public static SplitNode createNode(DockingPort port) {
        JSplitPane split;
        if (port == null) {
            return null;
        }
        Container c = ((Component)((Object)port)).getParent();
        JSplitPane jSplitPane = split = c instanceof JSplitPane ? (JSplitPane)c : null;
        if (split == null) {
            return null;
        }
        return DockingPath.createNode(port, split);
    }

    private static SplitNode createNode(DockingPort port, JSplitPane split) {
        int orientation = split.getOrientation();
        boolean topLeft = split.getLeftComponent() == port;
        int region = 0;
        String siblingId = null;
        if (topLeft) {
            region = orientation == 0 ? 1 : 2;
            siblingId = DockingPath.getSiblingId(split.getRightComponent());
        } else {
            region = orientation == 0 ? 3 : 4;
            siblingId = DockingPath.getSiblingId(split.getLeftComponent());
        }
        int size = orientation == 0 ? split.getHeight() : split.getWidth();
        int divLoc = split.getDividerLocation();
        int testSize = 0;
        testSize = orientation == 0 ? (testSize += split.getTopComponent().getHeight() + split.getBottomComponent().getHeight() + split.getDividerSize()) : (testSize += split.getLeftComponent().getWidth() + split.getRightComponent().getWidth() + split.getDividerSize());
        float percentage = split instanceof DockingSplitPane && ((DockingSplitPane)split).getPercent() != -1.0 ? (float)((DockingSplitPane)split).getPercent() : (float)divLoc / (float)size;
        return new SplitNode(orientation, region, percentage, siblingId);
    }

    private static String getSiblingId(Component c) {
        Dockable dockable;
        if (c instanceof DockingPort) {
            c = ((DockingPort)((Object)c)).getDockedComponent();
        }
        return (dockable = DockingPath.findDockable(c)) == null ? null : dockable.getPersistentId();
    }

    private static boolean isDockingRoot(Container c) {
        return c instanceof DockingPort && ((DockingPort)((Object)c)).isRoot();
    }

    public static DockingPath getRestorePath(Dockable dockable) {
        Object obj = dockable == null ? null : dockable.getClientProperty(RESTORE_PATH_KEY);
        return obj instanceof DockingPath ? (DockingPath)obj : null;
    }

    public static DockingPath updateRestorePath(Dockable dockable, DockingPath restorePath) {
        if (dockable == null || restorePath == null) {
            return null;
        }
        dockable.putClientProperty(RESTORE_PATH_KEY, restorePath);
        return restorePath;
    }

    private DockingPath(Dockable dockable) {
        this.siblingId = this.findSiblingId(dockable);
        this.tabbed = dockable.getComponent().getParent() instanceof JTabbedPane;
        this.nodes = new ArrayList();
    }

    public boolean isTabbed() {
        return this.tabbed;
    }

    public void setTabbed(boolean isTabbed) {
        this.tabbed = isTabbed;
    }

    public String getSiblingId() {
        return this.siblingId;
    }

    public void setSiblingId(String siblingId) {
        this.siblingId = siblingId;
    }

    private DockingPath(String parent, boolean tabs, ArrayList nodeList) {
        this.siblingId = parent;
        this.tabbed = tabs;
        this.nodes = nodeList;
    }

    public List getNodes() {
        return this.nodes;
    }

    public DockingPort getRootPort() {
        return DockingManager.getDockingPort(this.rootPortId);
    }

    public String getRootPortId() {
        return this.rootPortId;
    }

    public void setRootPortId(String portId) {
        this.rootPortId = portId;
    }

    private void addNode(SplitNode node) {
        this.nodes.add(node);
    }

    private void initialize() {
        Collections.reverse(this.nodes);
    }

    private String findSiblingId(Dockable dockable) {
        Dockable d;
        JSplitPane split;
        Component comp = dockable.getComponent();
        JSplitPane jSplitPane = split = comp.getParent() instanceof JSplitPane ? (JSplitPane)comp.getParent() : null;
        if (split == null) {
            return null;
        }
        Component sibling = split.getLeftComponent();
        if (comp == sibling) {
            sibling = split.getRightComponent();
        }
        return (d = DockingPath.findDockable(sibling)) == null ? null : d.getPersistentId();
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer sb = new StringBuffer("/RootPort[id=").append(this.rootPortId).append("]");
            for (SplitNode node : this.nodes) {
                sb.append("/").append(node.toString());
            }
            sb.append("/Dockable");
            this.stringForm = sb.toString();
        }
        return this.stringForm;
    }

    public boolean restore(String dockable) {
        return this.restore(DockingManager.getDockable(dockable));
    }

    private DockingPort getRootDockingPort() {
        DockingPort port = DockingManager.getDockingPort(this.rootPortId);
        if (port != null) {
            return port;
        }
        Window activeWindow = SwingUtility.getActiveWindow();
        return DockingManager.getRootDockingPort(activeWindow);
    }

    public boolean restore(Dockable dockable) {
        if (dockable == null || DockingPath.isDocked(dockable)) {
            return false;
        }
        DockingPort rootPort = this.getRootDockingPort();
        String region = "CENTER";
        if (this.nodes.isEmpty()) {
            return this.dockFullPath(dockable, rootPort, region);
        }
        DockingPort port = rootPort;
        for (SplitNode node : this.nodes) {
            JSplitPane splitPane;
            Component comp = port.getDockedComponent();
            region = this.getRegion(node, comp);
            JSplitPane jSplitPane = splitPane = comp instanceof JSplitPane ? (JSplitPane)comp : null;
            if (splitPane == null || splitPane.getOrientation() != node.getOrientation()) {
                return this.dockBrokenPath(dockable, port, region, node);
            }
            comp = node.getRegion() == 2 || node.getRegion() == 1 ? splitPane.getLeftComponent() : splitPane.getRightComponent();
            port = (DockingPort)((Object)comp);
        }
        return this.dockFullPath(dockable, port, region);
    }

    private boolean dockBrokenPath(Dockable dockable, DockingPort port, String region, SplitNode ctrlNode) {
        SplitNode lastNode;
        Component current = port.getDockedComponent();
        if (current instanceof JSplitPane) {
            return this.dockExtendedPath(dockable, port, region, ctrlNode);
        }
        if (current instanceof JTabbedPane) {
            return this.dock(dockable, port, "CENTER", null);
        }
        Dockable embedded = DockingPath.findDockable(current);
        if (embedded == null || this.tabbed) {
            return this.dock(dockable, port, "CENTER", null);
        }
        String embedId = embedded.getPersistentId();
        if (embedId.equals((lastNode = this.getLastNode()).getSiblingId())) {
            region = this.getRegion(lastNode, current);
            ctrlNode = lastNode;
        }
        return this.dock(dockable, port, region, ctrlNode);
    }

    private boolean dockFullPath(Dockable dockable, DockingPort port, String region) {
        Component current = port.getDockedComponent();
        if (current instanceof JTabbedPane) {
            return this.dock(dockable, port, "CENTER", null);
        }
        Dockable docked = DockingPath.findDockable(current);
        if (docked != null) {
            Component comp = dockable.getComponent();
            if (port.isDockingAllowed(comp, "CENTER")) {
                return this.dock(dockable, port, "CENTER", null);
            }
            DockingPort superPort = (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, (Component)((Object)port)));
            if (superPort != null) {
                port = superPort;
            }
            return this.dock(dockable, port, region, this.getLastNode());
        }
        return this.dockExtendedPath(dockable, port, region, this.getLastNode());
    }

    private boolean dockExtendedPath(Dockable dockable, DockingPort port, String region, SplitNode ctrlNode) {
        Component docked = port.getDockedComponent();
        if (docked != null && !(docked instanceof JSplitPane)) {
            Throwable t = new Throwable("Docked: " + docked);
            System.err.println("Exception: " + t.getMessage());
            return false;
        }
        SplitNode lastNode = this.getLastNode();
        String lastSibling = lastNode == null ? null : lastNode.getSiblingId();
        Set dockables = port.getDockables();
        Iterator it = dockables.iterator();
        while (lastSibling != null && it.hasNext()) {
            Dockable d = (Dockable)it.next();
            if (!d.getPersistentId().equals(lastSibling)) continue;
            DockingPort embedPort = d.getDockingPort();
            String embedRegion = this.getRegion(lastNode, d.getComponent());
            return this.dock(dockable, embedPort, embedRegion, ctrlNode);
        }
        return this.dock(dockable, port, region, ctrlNode);
    }

    private String getRegion(SplitNode node, Component dockedComponent) {
        if (dockedComponent == null) {
            return "CENTER";
        }
        return DockingUtility.getRegion(node.getRegion());
    }

    public SplitNode getLastNode() {
        return this.nodes.isEmpty() ? null : (SplitNode)this.nodes.get(this.nodes.size() - 1);
    }

    private boolean dock(Dockable dockable, DockingPort port, String region, SplitNode ctrlNode) {
        boolean ret = DockingManager.dock(dockable, port, region);
        if (this.tabbed || ctrlNode == null) {
            return ret;
        }
        final float percent = ctrlNode.getPercentage();
        final Component docked = dockable.getComponent();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockingPath.this.resizeSplitPane(docked, percent);
            }
        });
        return ret;
    }

    private void resizeSplitPane(Component comp, float percentage) {
        Container grandParent;
        Container parent = comp.getParent();
        Container container = grandParent = parent == null ? null : parent.getParent();
        if (!(grandParent instanceof JSplitPane)) {
            return;
        }
        JSplitPane split = (JSplitPane)grandParent;
        split.setDividerLocation(percentage);
    }

    private static Dockable findDockable(Component c) {
        return DockingManager.getDockable(c);
    }

    private static Dockable findDockable(String id) {
        return DockingManager.getDockable(id);
    }

    private static boolean isDocked(Dockable dockable) {
        return DockingManager.isDocked(dockable);
    }

    public int getDepth() {
        return this.nodes.size();
    }

    public SplitNode getNode(int indx) {
        return indx < 0 || indx >= this.getDepth() ? null : (SplitNode)this.nodes.get(indx);
    }

    public Object clone() {
        ArrayList<Object> nodeList = null;
        if (this.nodes != null) {
            nodeList = new ArrayList<Object>(this.nodes.size());
            for (SplitNode node : this.nodes) {
                nodeList.add(node.clone());
            }
        }
        DockingPath path = new DockingPath(this.siblingId, this.tabbed, nodeList);
        path.rootPortId = this.rootPortId;
        return path;
    }
}

