/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.props;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.props.BasicDockablePropertySet;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.docking.props.RootDockablePropertySet;
import org.flexdock.docking.props.ScopedMap;

public class ScopedDockablePropertySet
extends BasicDockablePropertySet
implements ScopedMap {
    public static final RootDockablePropertySet ROOT_PROPS = new RootDockablePropertySet(null);
    public static final List DEFAULTS = new ArrayList(0);
    public static final List GLOBALS = new ArrayList(0);
    private ArrayList locals;

    public ScopedDockablePropertySet(Dockable dockable) {
        this(6, dockable);
        this.init();
    }

    public ScopedDockablePropertySet(int initialCapacity, Dockable dockable) {
        super(initialCapacity, dockable);
        this.init();
    }

    public ScopedDockablePropertySet(int initialCapacity, float loadFactor, Dockable dockable) {
        super(initialCapacity, loadFactor, dockable);
        this.init();
    }

    public ScopedDockablePropertySet(Map t, Dockable dockable) {
        super(t, dockable);
        this.init();
    }

    @Override
    public List getLocals() {
        return this.locals;
    }

    @Override
    public List getDefaults() {
        return DEFAULTS;
    }

    @Override
    public List getGlobals() {
        return GLOBALS;
    }

    @Override
    public Map getRoot() {
        return ROOT_PROPS;
    }

    @Override
    public String getDockableDesc() {
        return (String)PropertyManager.getProperty((Object)"Dockable.DESCRIPTION", this);
    }

    @Override
    public Boolean isDockingEnabled() {
        return (Boolean)PropertyManager.getProperty((Object)"Dockable.DOCKING_ENABLED", this);
    }

    @Override
    public Boolean isActive() {
        return (Boolean)PropertyManager.getProperty((Object)"Dockable.ACTIVE", this);
    }

    @Override
    public Boolean isMouseMotionListenersBlockedWhileDragging() {
        return (Boolean)PropertyManager.getProperty((Object)"Dockable.MOUSE_MOTION_DRAG_BLOCK", this);
    }

    @Override
    public Float getRegionInset(String region) {
        String key = ScopedDockablePropertySet.getRegionInsetKey(region);
        return key == null ? null : (Float)PropertyManager.getProperty((Object)key, this);
    }

    @Override
    public Float getSiblingSize(String region) {
        String key = ScopedDockablePropertySet.getSiblingSizeKey(region);
        return key == null ? null : (Float)PropertyManager.getProperty((Object)key, this);
    }

    @Override
    public Boolean isTerritoryBlocked(String region) {
        String key = ScopedDockablePropertySet.getTerritoryBlockedKey(region);
        return key == null ? null : (Boolean)PropertyManager.getProperty((Object)key, this);
    }

    @Override
    public Float getDragThreshold() {
        return (Float)PropertyManager.getProperty((Object)"Dockable.DRAG_THRESHOLD", this);
    }

    @Override
    public Float getPreviewSize() {
        return (Float)PropertyManager.getProperty((Object)"Dockable.PREVIEW_SIZE", this);
    }

    private void init() {
        this.locals = new ArrayList(1);
        this.locals.add(this);
    }
}

