/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.props;

import java.util.Map;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.RegionChecker;
import org.flexdock.docking.props.DockingPortPropertySet;
import org.flexdock.util.TypedHashtable;

public class BasicDockingPortPropertySet
extends TypedHashtable
implements DockingPortPropertySet,
DockingConstants {
    public static String getRegionInsetKey(String region) {
        if ("NORTH".equals(region)) {
            return "DockingPort.REGION_SIZE_NORTH";
        }
        if ("SOUTH".equals(region)) {
            return "DockingPort.REGION_SIZE_SOUTH";
        }
        if ("EAST".equals(region)) {
            return "DockingPort.REGION_SIZE_EAST";
        }
        if ("WEST".equals(region)) {
            return "DockingPort.REGION_SIZE_WEST";
        }
        return null;
    }

    public BasicDockingPortPropertySet() {
    }

    public BasicDockingPortPropertySet(int initialCapacity) {
        super(initialCapacity);
    }

    public BasicDockingPortPropertySet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public BasicDockingPortPropertySet(Map t) {
        super(t);
    }

    @Override
    public RegionChecker getRegionChecker() {
        return (RegionChecker)this.get("DockingPort.REGION_CHECKER");
    }

    @Override
    public Boolean isSingleTabsAllowed() {
        return this.getBoolean("DockingPort.SINGLE_TABS");
    }

    @Override
    public Integer getTabPlacement() {
        return this.getInt("DockingPort.TAB_PLACEMENT");
    }

    @Override
    public Float getRegionInset(String region) {
        String key = BasicDockingPortPropertySet.getRegionInsetKey(region);
        return key == null ? null : (Float)this.get(key);
    }

    @Override
    public void setRegionChecker(RegionChecker checker) {
        this.put((Object)"DockingPort.REGION_CHECKER", checker);
    }

    @Override
    public void setSingleTabsAllowed(boolean allowed) {
        this.put((Object)"DockingPort.SINGLE_TABS", allowed);
    }

    @Override
    public void setTabPlacement(int placement) {
        this.put((Object)"DockingPort.TAB_PLACEMENT", placement);
    }

    @Override
    public void setRegionInset(String region, float inset) {
        String key = BasicDockingPortPropertySet.getRegionInsetKey(region);
        if (key != null) {
            this.put((Object)key, new Float(inset));
        }
    }
}

