/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLayeredPane;
import org.flexdock.docking.floating.frames.RootPane;

public class RootPaneLayout
implements LayoutManager2,
Serializable {
    private RootPane pane;

    RootPaneLayout(RootPane pane) {
        this.pane = pane;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = this.pane.getInsets();
        int preferredWidth = 0;
        int preferredHeight = 0;
        Container contentPane = this.pane.getContentPane();
        if (contentPane != null) {
            preferredWidth = contentPane.getPreferredSize().width;
            preferredHeight = contentPane.getPreferredSize().height;
        } else {
            preferredWidth = parent.getSize().width;
            preferredHeight = parent.getSize().height;
        }
        return new Dimension(preferredWidth + insets.left + insets.right, preferredHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = this.pane.getInsets();
        int minimumWidth = 0;
        int minimumHeight = 0;
        Container contentPane = this.pane.getContentPane();
        if (contentPane != null) {
            minimumWidth = contentPane.getMinimumSize().width;
            minimumHeight = contentPane.getMinimumSize().height;
        } else {
            minimumWidth = parent.getSize().width;
            minimumHeight = parent.getSize().height;
        }
        return new Dimension(minimumWidth + insets.left + insets.right, minimumHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        Insets i = this.pane.getInsets();
        Dimension mbd = new Dimension(0, 0);
        Container contentPane = this.pane.getContentPane();
        Dimension rd = contentPane != null ? contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom - mbd.height - 1);
        return new Dimension(Math.min(rd.width, mbd.width) + i.left + i.right, rd.height + mbd.height + i.top + i.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        Component glassPane;
        Rectangle bounds = parent.getBounds();
        Insets insets = this.pane.getInsets();
        int w = bounds.width - insets.right - insets.left;
        int h = bounds.height - insets.top - insets.bottom;
        JLayeredPane layeredPane = this.pane.getLayeredPane();
        if (layeredPane != null) {
            layeredPane.setBounds(insets.left, insets.top, w, h);
        }
        if ((glassPane = this.pane.getGlassPane()) != null) {
            glassPane.setBounds(insets.left, insets.top, w, h);
        }
        int contentY = 0;
        Container contentPane = this.pane.getContentPane();
        if (contentPane != null) {
            contentPane.setBounds(0, contentY, w, h - contentY);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

