/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.frames;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.docking.floating.frames.RootPaneBorder;
import org.flexdock.docking.floating.frames.RootPaneLayout;

public class RootPane
extends JRootPane
implements MouseListener,
MouseMotionListener {
    private static final int CORNER_MARGIN = 5;
    private int currentResizeRegion;
    private Rectangle mMouseLimits;
    private Cursor mLastCursor;
    private Point offset;
    private DockingFrame frame;

    RootPane(DockingFrame frame) {
        this.frame = frame;
        this.setBorder(new RootPaneBorder());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.offset = new Point();
    }

    void ensureValidScreenBounds(Point attemptedPoint) {
        if (attemptedPoint.x < this.mMouseLimits.x) {
            attemptedPoint.x = this.mMouseLimits.x;
        } else if (attemptedPoint.x > this.mMouseLimits.x + this.mMouseLimits.width) {
            attemptedPoint.x = this.mMouseLimits.x + this.mMouseLimits.width;
        }
        if (attemptedPoint.y < this.mMouseLimits.y) {
            attemptedPoint.y = this.mMouseLimits.y;
        } else if (attemptedPoint.y > this.mMouseLimits.y + this.mMouseLimits.height) {
            attemptedPoint.y = this.mMouseLimits.y + this.mMouseLimits.height;
        }
    }

    void computeMouseLimits(Point p) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mMouseLimits = new Rectangle(0, 0, screenSize.width, screenSize.height);
        Rectangle currFrameRect = this.frame.getBounds();
        Dimension minSize = this.getLayout().minimumLayoutSize(this.getParent());
        int minWidth = minSize.width;
        int minHeight = minSize.height;
        switch (this.currentResizeRegion) {
            case 6: {
                this.mMouseLimits.width = currFrameRect.x + currFrameRect.width - minWidth - this.mMouseLimits.x;
                this.mMouseLimits.height = currFrameRect.y + currFrameRect.height - minHeight - this.mMouseLimits.y;
                this.offset.setLocation(-p.x, -p.y);
                break;
            }
            case 8: {
                this.mMouseLimits.height = currFrameRect.y + currFrameRect.height - minHeight - this.mMouseLimits.y;
                this.offset.setLocation(0, -p.y);
                break;
            }
            case 7: {
                this.mMouseLimits.x = currFrameRect.x + minWidth;
                this.mMouseLimits.height = currFrameRect.y + currFrameRect.height - minHeight - this.mMouseLimits.y;
                this.offset.setLocation(this.getWidth() - p.x, -p.y);
                break;
            }
            case 11: {
                this.mMouseLimits.x = currFrameRect.x + minWidth;
                this.offset.setLocation(this.getWidth() - p.x, 0);
                break;
            }
            case 5: {
                this.mMouseLimits.y = currFrameRect.y + minHeight;
                this.mMouseLimits.x = currFrameRect.x + minWidth;
                this.offset.setLocation(this.getWidth() - p.x, this.getHeight() - p.y);
                break;
            }
            case 9: {
                this.mMouseLimits.y = currFrameRect.y + minHeight;
                this.offset.setLocation(0, this.getHeight() - p.y);
                break;
            }
            case 4: {
                this.mMouseLimits.y = currFrameRect.y + minHeight;
                this.mMouseLimits.width = currFrameRect.x + currFrameRect.width - minWidth - this.mMouseLimits.x;
                this.offset.setLocation(-p.x, this.getHeight() - p.y);
                break;
            }
            case 10: {
                this.mMouseLimits.width = currFrameRect.x + currFrameRect.width - minWidth - this.mMouseLimits.x;
                this.offset.setLocation(-p.x, 0);
            }
        }
    }

    private int getCursor(Point p) {
        Insets insets = this.getInsets();
        if (p.x <= insets.left) {
            if (p.y <= 5) {
                return 6;
            }
            if (p.y >= this.getHeight() - 5) {
                return 4;
            }
            return 10;
        }
        if (p.x >= this.getWidth() - insets.right) {
            if (p.y <= 5) {
                return 7;
            }
            if (p.y >= this.getHeight() - 5) {
                return 5;
            }
            return 11;
        }
        if (p.y <= insets.top) {
            if (p.x <= 5) {
                return 6;
            }
            if (p.x >= this.getWidth() - 5) {
                return 7;
            }
            return 8;
        }
        if (p.y >= this.getHeight() - insets.bottom) {
            if (p.x <= 5) {
                return 4;
            }
            if (p.x >= this.getWidth() - 5) {
                return 5;
            }
            return 9;
        }
        return 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentResizeRegion = this.getCursor(e.getPoint());
        this.computeMouseLimits(e.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentResizeRegion == 0) {
            return;
        }
        Point p = (Point)e.getPoint().clone();
        p.x += this.offset.x;
        p.y += this.offset.y;
        SwingUtilities.convertPointToScreen(p, this);
        this.ensureValidScreenBounds(p);
        Rectangle bounds = this.frame.getBounds();
        switch (this.currentResizeRegion) {
            case 6: {
                this.frame.setBounds(p.x, p.y, bounds.width + bounds.x - p.x, bounds.height + bounds.y - p.y);
                break;
            }
            case 8: {
                this.frame.setBounds(bounds.x, p.y, bounds.width, bounds.height + bounds.y - p.y);
                break;
            }
            case 7: {
                this.frame.setBounds(bounds.x, p.y, p.x - bounds.x, bounds.height + bounds.y - p.y);
                break;
            }
            case 10: {
                this.frame.setBounds(p.x, bounds.y, bounds.x + bounds.width - p.x, bounds.height);
                break;
            }
            case 11: {
                this.frame.setBounds(bounds.x, bounds.y, p.x - bounds.x, bounds.height);
                break;
            }
            case 4: {
                this.frame.setBounds(p.x, bounds.y, bounds.width + bounds.x - p.x, p.y - bounds.y);
                break;
            }
            case 9: {
                this.frame.setBounds(bounds.x, bounds.y, bounds.width, p.y - bounds.y);
                break;
            }
            case 5: {
                this.frame.setBounds(bounds.x, bounds.y, p.x - bounds.x, p.y - bounds.y);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(this.currentResizeRegion));
        this.frame.validate();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.currentResizeRegion = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(this.getCursor(e.getPoint())));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.currentResizeRegion == 0) {
            this.mLastCursor = this.getCursor();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(this.mLastCursor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    protected LayoutManager createRootLayout() {
        return new RootPaneLayout(this);
    }
}

