/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.frames;

import java.awt.Component;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.docking.floating.frames.FrameDragListener;

public class FloatingDockingPort
extends DefaultDockingPort {
    private static final Set EMPTY_SET = new HashSet(0);
    protected DockingFrame frame;
    protected FrameDragListener dragListener;

    public FloatingDockingPort(DockingFrame frame, String persistentId) {
        super(persistentId);
        this.getDockingProperties().setSingleTabsAllowed(true);
        this.setTabsAsDragSource(true);
        this.frame = frame;
        this.dragListener = new FrameDragListener(frame);
    }

    @Override
    public String getRegion(Point p) {
        return "CENTER";
    }

    public boolean isDockingAllowed(String region, Component comp) {
        if (!"CENTER".equals(region)) {
            return false;
        }
        return super.isDockingAllowed(comp, region);
    }

    @Override
    public boolean dock(Dockable dockable, String region) {
        boolean ret = super.dock(dockable, "CENTER");
        if (ret) {
            this.toggleListeners(dockable.getComponent(), true);
        }
        return ret;
    }

    @Override
    public boolean undock(Component comp) {
        boolean ret = super.undock(comp);
        if (ret) {
            this.toggleListeners(comp, false);
        }
        return ret;
    }

    @Override
    public void dragStarted(DockingEvent evt) {
        super.dragStarted(evt);
        Component dragSrc = (Component)evt.getTriggerSource();
        Dockable dockable = (Dockable)evt.getSource();
        boolean listenerEnabled = this.getFrameDragSources(dockable).contains(dragSrc);
        this.dragListener.setEnabled(listenerEnabled);
        if (listenerEnabled) {
            evt.consume();
        }
    }

    @Override
    public void undockingComplete(DockingEvent evt) {
        super.undockingComplete(evt);
        if (evt.getOldDockingPort() == this && this.getDockableCount() == 0) {
            this.frame.destroy();
            this.frame = null;
        }
    }

    protected void toggleListeners(Component comp, boolean add) {
        Dockable dockable = DockingManager.getDockable(comp);
        if (add) {
            this.installListeners(dockable);
        } else {
            this.uninstallListeners(dockable);
        }
    }

    protected void installListeners(Dockable dockable) {
        Set frameDraggers = this.getFrameDragSources(dockable);
        for (Component frameDragSrc : frameDraggers) {
            frameDragSrc.addMouseListener(this.dragListener);
            frameDragSrc.addMouseMotionListener(this.dragListener);
        }
        dockable.addDockingListener(this);
    }

    protected void uninstallListeners(Dockable dockable) {
        Set frameDraggers = this.getFrameDragSources(dockable);
        for (Component frameDragSrc : frameDraggers) {
            frameDragSrc.removeMouseListener(this.dragListener);
            frameDragSrc.removeMouseMotionListener(this.dragListener);
        }
        dockable.removeDockingListener(this);
    }

    public int getDockableCount() {
        Component comp = this.getDockedComponent();
        if (!(comp instanceof JTabbedPane)) {
            return 0;
        }
        return ((JTabbedPane)comp).getTabCount();
    }

    protected Set getFrameDragSources(Dockable dockable) {
        Set set = dockable == null ? null : dockable.getFrameDragSources();
        return set == null ? EMPTY_SET : set;
    }
}

