/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.frames;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.floating.frames.FloatingDockingPort;
import org.flexdock.docking.floating.frames.RootPane;
import org.flexdock.docking.state.FloatingGroup;
import org.flexdock.util.RootWindow;

public class DockingFrame
extends JDialog
implements DockingConstants {
    private static final BoundsMonitor BOUNDS_MONITOR = new BoundsMonitor();
    private FloatingDockingPort dockingPort;
    private String groupName;

    public static DockingFrame create(Component c, String groupName) {
        RootWindow rootWin = RootWindow.getRootContainer(c);
        Component window = rootWin.getRootContainer();
        if (window instanceof DockingFrame) {
            window = ((Window)window).getOwner();
        }
        if (window instanceof Applet) {
            window = SwingUtilities.windowForComponent(window);
        }
        if (window instanceof Frame) {
            return new DockingFrame((Frame)window, groupName);
        }
        if (window instanceof Dialog) {
            return new DockingFrame((Dialog)window, groupName);
        }
        return null;
    }

    public DockingFrame(Frame owner, String groupName) {
        super(owner);
        this.initialize(groupName);
    }

    public DockingFrame(Dialog owner, String groupName) {
        super(owner);
        this.initialize(groupName);
    }

    private void initialize(String groupName) {
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.dockingPort = new FloatingDockingPort(this, null);
        this.setContentPane(this.dockingPort);
        this.groupName = groupName;
        this.addComponentListener(BOUNDS_MONITOR);
    }

    @Override
    protected JRootPane createRootPane() {
        return new RootPane(this);
    }

    public DockingPort getDockingPort() {
        return this.dockingPort;
    }

    public void addDockable(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        this.dockingPort.dock(dockable, "CENTER");
    }

    public void destroy() {
        this.setVisible(false);
        this.dockingPort = null;
        FloatingGroup group = this.getGroup();
        if (group != null) {
            group.setFrame(null);
        }
        this.dispose();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public FloatingGroup getGroup() {
        return DockingManager.getFloatManager().getGroup(this.getGroupName());
    }

    private static class BoundsMonitor
    implements ComponentListener {
        private BoundsMonitor() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.updateBounds(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.updateBounds(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.updateBounds(e);
        }

        private void updateBounds(ComponentEvent evt) {
            Component c = evt.getComponent();
            if (!(c instanceof DockingFrame)) {
                return;
            }
            DockingFrame frame = (DockingFrame)c;
            FloatingGroup group = frame.getGroup();
            if (group != null) {
                group.setBounds(frame.getBounds());
            }
        }
    }
}

