/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.event;

import java.util.EventListener;
import java.util.Vector;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.event.DockingMonitor;
import org.flexdock.event.Event;
import org.flexdock.event.EventHandler;

public class DockingEventHandler
extends EventHandler {
    private static final String DOCKING_LISTENERS_KEY = "EventManager.DOCKING_LISTENERS_KEY";

    public static DockingListener[] getDockingListeners(Dockable dockable) {
        Vector list = DockingEventHandler.getDockingListenersList(dockable);
        return list == null ? null : list.toArray(new DockingListener[0]);
    }

    public static void addDockingListener(Dockable dockable, DockingListener listener) {
        if (dockable != null && listener != null) {
            DockingEventHandler.getDockingListenersList(dockable).add(listener);
        }
    }

    public static void removeDockingListener(Dockable dockable, DockingListener listener) {
        if (dockable != null && listener != null) {
            DockingEventHandler.getDockingListenersList(dockable).remove(listener);
        }
    }

    private static Vector getDockingListenersList(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Vector list = (Vector)dockable.getClientProperty(DOCKING_LISTENERS_KEY);
        if (list == null) {
            list = new Vector();
            dockable.putClientProperty(DOCKING_LISTENERS_KEY, list);
        }
        return list;
    }

    @Override
    public boolean acceptsEvent(Event evt) {
        return evt instanceof DockingEvent;
    }

    @Override
    public boolean acceptsListener(EventListener listener) {
        return listener instanceof DockingListener;
    }

    @Override
    public void handleEvent(Event evt, EventListener listener, int eventType) {
        DockingEvent event = (DockingEvent)evt;
        DockingListener consumer = (DockingListener)listener;
        switch (event.getEventType()) {
            case 0: {
                consumer.dragStarted(event);
                break;
            }
            case 1: {
                consumer.dropStarted(event);
                break;
            }
            case 2: {
                consumer.dockingComplete(event);
                break;
            }
            case 3: {
                consumer.dockingCanceled(event);
                break;
            }
            case 4: {
                consumer.undockingComplete(event);
                break;
            }
            case 5: {
                consumer.undockingStarted(event);
            }
        }
    }

    @Override
    public EventListener[] getListeners(Object eventTarget) {
        return eventTarget instanceof DockingMonitor ? ((DockingMonitor)eventTarget).getDockingListeners() : null;
    }
}

