/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.drag.DragOperation;
import org.flexdock.docking.drag.DragPipeline;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.floating.policy.FloatPolicyManager;
import org.flexdock.event.Event;
import org.flexdock.event.EventManager;
import org.flexdock.util.DockingUtility;

public class DragManager
extends MouseAdapter
implements MouseMotionListener {
    private static final String DRAG_CONTEXT = "DragManager.DRAG_CONTEXT";
    private static final Object LOCK = new Object();
    private static DragOperation currentDragOperation;
    private Dockable dockable;
    private DragPipeline pipeline;
    private boolean enabled;
    private Point dragOrigin;
    private HashMap dragContext;

    public static void prime() {
        EffectsManager.prime();
    }

    public DragManager(Dockable dockable) {
        this.dockable = dockable;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.dockable == null || this.dockable.getDockingProperties().isDockingEnabled() == Boolean.FALSE) {
            this.enabled = false;
        } else {
            this.toggleDragContext(true);
            this.enabled = !DragManager.isDragCanceled(this.dockable, e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!this.enabled) {
            return;
        }
        if (this.dragOrigin == null) {
            this.dragOrigin = evt.getPoint();
        }
        if (this.pipeline == null || !this.pipeline.isOpen()) {
            if (this.passedDragThreshold(evt)) {
                this.openPipeline(evt);
            } else {
                evt.consume();
            }
        } else {
            this.pipeline.processDragEvent(evt);
        }
    }

    private boolean passedDragThreshold(MouseEvent evt) {
        float threshold;
        double distance = this.dragOrigin.distance(evt.getPoint());
        return distance > (double)(threshold = this.dockable.getDockingProperties().getDragThreshold().floatValue());
    }

    private void openPipeline(MouseEvent evt) {
        DragPipeline pipeline;
        DragOperation token = new DragOperation(this.dockable.getComponent(), this.dragOrigin, evt);
        token.setDragListener(this);
        DragManager.initializeListenerCaching(token);
        this.pipeline = pipeline = new DragPipeline();
        pipeline.open(token);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pipeline == null || this.dockable.getDockingProperties().isDockingEnabled() == Boolean.FALSE) {
            return;
        }
        this.finishDrag(this.dockable, this.pipeline.getDragToken(), e);
        if (this.pipeline != null) {
            this.pipeline.close();
        }
        this.toggleDragContext(false);
        this.dragOrigin = null;
        this.pipeline = null;
    }

    protected void finishDrag(Dockable dockable, DragOperation token, MouseEvent mouseEvt) {
        DockingStrategy docker = DockingManager.getDockingStrategy(dockable);
        DockingPort currentPort = DockingUtility.getParentDockingPort(dockable);
        DockingPort targetPort = token.getTargetPort();
        String region = token.getTargetRegion();
        DragManager.restoreCachedListeners(token);
        DockingEvent evt = new DockingEvent(dockable, currentPort, targetPort, 1, mouseEvt, this.getDragContext());
        evt.setRegion(region);
        evt.setOverWindow(token.isOverWindow());
        EventManager.dispatch((Event)evt, dockable);
        if (!evt.isConsumed()) {
            docker.dock(dockable, targetPort, region, token);
        }
    }

    private static void initializeListenerCaching(DragOperation token) {
        Component dragSrc = token.getDragSource();
        EventListener[] cachedListeners = dragSrc.getListeners(MouseMotionListener.class);
        token.setCachedListeners(cachedListeners);
        DragManager dragListener = token.getDragListener();
        for (int i = 0; i < cachedListeners.length; ++i) {
            dragSrc.removeMouseMotionListener((MouseMotionListener)cachedListeners[i]);
        }
        if (dragListener != null) {
            dragSrc.addMouseMotionListener(dragListener);
        }
    }

    private static void restoreCachedListeners(DragOperation token) {
        Component dragSrc = token.getDragSource();
        EventListener[] cachedListeners = token.getCachedListeners();
        DragManager dragListener = token.getDragListener();
        if (dragListener != null) {
            dragSrc.removeMouseMotionListener(dragListener);
        }
        for (int i = 0; i < cachedListeners.length; ++i) {
            dragSrc.addMouseMotionListener((MouseMotionListener)cachedListeners[i]);
        }
    }

    private static boolean isDragCanceled(Dockable dockable, MouseEvent trigger) {
        DockingPort port = DockingUtility.getParentDockingPort(dockable);
        Map dragContext = DragManager.getDragContext(dockable);
        DockingEvent evt = new DockingEvent(dockable, port, null, 0, trigger, dragContext);
        EventManager.dispatch((Event)evt, dockable);
        return evt.isConsumed();
    }

    public static Map getDragContext(Dockable dockable) {
        Object obj = dockable == null ? null : dockable.getClientProperty(DRAG_CONTEXT);
        return obj instanceof Map ? (Map)obj : null;
    }

    private void toggleDragContext(boolean add) {
        if (add) {
            if (this.dragContext == null) {
                this.dragContext = new HashMap();
                this.dockable.putClientProperty(DRAG_CONTEXT, this.dragContext);
            }
        } else {
            if (this.dragContext != null) {
                this.dragContext.clear();
                this.dragContext = null;
            }
            this.dockable.putClientProperty(DRAG_CONTEXT, null);
        }
    }

    private Map getDragContext() {
        return DragManager.getDragContext(this.dockable);
    }

    public static boolean isFloatingAllowed(Dockable dockable) {
        return FloatPolicyManager.isFloatingAllowed(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DragOperation getCurrentDragOperation() {
        Object object = LOCK;
        synchronized (object) {
            return currentDragOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentDragOperation(DragOperation operation) {
        Object object = LOCK;
        synchronized (object) {
            currentDragOperation = operation;
        }
    }
}

