/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.drag.DragManager;
import org.flexdock.docking.drag.DragOperation;
import org.flexdock.docking.drag.effects.DragPreview;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.util.NestedComponents;
import org.flexdock.util.RootWindow;

public class DragGlasspane
extends JComponent
implements DockingConstants {
    private NestedComponents currentDropTargets;
    private Component cachedGlassPane;
    private RootWindow rootWindow;
    private Runnable postPainter;
    private DragPreview previewDelegate;
    private boolean previewInit;
    private Polygon previewPoly;
    private DragOperation currentDragToken;

    public DragGlasspane() {
        this.setLayout(null);
    }

    public Component getCachedGlassPane() {
        return this.cachedGlassPane;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    public void setCachedGlassPane(Component cachedGlassPane) {
        this.cachedGlassPane = cachedGlassPane;
    }

    public void setRootWindow(RootWindow rootWindow) {
        this.rootWindow = rootWindow;
    }

    private NestedComponents getDropTargets(DragOperation token) {
        Container c = this.rootWindow.getContentPane();
        Point currMouse = token.getCurrentMouse(c);
        Component deep = SwingUtilities.getDeepestComponentAt(c, currMouse.x, currMouse.y);
        return NestedComponents.find(deep, Dockable.class, DockingPort.class);
    }

    public void processDragEvent(DragOperation token) {
        this.currentDragToken = token;
        NestedComponents dropTargets = this.getDropTargets(token);
        if (this.currentDropTargets == null && dropTargets == null) {
            this.deferPostPaint();
            return;
        }
        String region = null;
        this.setPostPainter(null);
        this.currentDropTargets = dropTargets;
        DockingPort port = dropTargets == null ? null : (DockingPort)((Object)dropTargets.parent);
        Dockable hover = this.getHoverDockable(dropTargets);
        Point mousePoint = token.getCurrentMouse((Component)((Object)port));
        region = this.findRegion(port, hover, mousePoint);
        token.setTarget(port, region);
        this.createPreviewPolygon(token, port, hover, region);
        this.repaint();
    }

    private String findRegion(DockingPort hoverPort, Dockable hoverDockable, Point mousePoint) {
        if (hoverPort == null) {
            return "UNKNOWN";
        }
        if (hoverDockable != null) {
            return hoverPort.getRegion(mousePoint);
        }
        Component docked = hoverPort.getDockedComponent();
        if (docked == null) {
            return hoverPort.getRegion(mousePoint);
        }
        return "UNKNOWN";
    }

    private Dockable getHoverDockable(NestedComponents nest) {
        Component c;
        Component component = c = nest == null ? null : nest.child;
        if (c instanceof Dockable) {
            return (Dockable)((Object)c);
        }
        return DockingManager.getDockable(c);
    }

    protected void createPreviewPolygon(DragOperation token, DockingPort port, Dockable hover, String region) {
        DragPreview preview = this.getPreviewDelegate(token.getDockable(), port);
        if (preview == null) {
            this.previewPoly = null;
        } else {
            Map dragContext = this.getDragContext(token);
            this.previewPoly = preview.createPreviewPolygon(token.getDockable(), port, hover, region, this, dragContext);
        }
    }

    public void clear() {
        if (this.currentDropTargets != null) {
            this.currentDropTargets = null;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponentImpl(g);
        this.postPaint(g);
    }

    protected void postPaint(Graphics g) {
        if (this.postPainter != null) {
            this.postPainter.run();
        }
        this.postPainter = null;
    }

    protected DragPreview getPreviewDelegate(Component dockable, DockingPort port) {
        if (!this.previewInit) {
            Dockable d = DockingManager.getDockable(dockable);
            this.previewDelegate = EffectsManager.getPreview(d, port);
            this.previewInit = true;
        }
        return this.previewDelegate;
    }

    private void deferPostPaint() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DragGlasspane.this.postPaint(DragGlasspane.this.getGraphics());
            }
        });
    }

    void setPostPainter(Runnable painter) {
        this.postPainter = painter;
    }

    protected void paintComponentImpl(Graphics g) {
        if (this.currentDragToken != null && this.previewDelegate != null && this.previewPoly != null) {
            Dockable dockable = this.currentDragToken.getDockableReference();
            Map dragInfo = this.getDragContext(this.currentDragToken);
            this.previewDelegate.drawPreview((Graphics2D)g, this.previewPoly, dockable, dragInfo);
        }
    }

    private Map getDragContext(DragOperation token) {
        if (token == null) {
            return null;
        }
        Dockable dockable = token.getDockableReference();
        return DragManager.getDragContext(dockable);
    }
}

