/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.SwingUtility;

public class DockingSplitPane
extends JSplitPane
implements DockingConstants {
    protected DockingPort dockingPort;
    protected String region;
    protected boolean dividerLocDetermined;
    protected boolean controllerInTopLeft;
    protected double initialDividerRatio = 0.5;
    protected double percent = -1.0;
    private int dividerHashCode = -1;
    private boolean constantPercent;

    public DockingSplitPane(DockingPort port, String region) {
        if (port == null) {
            throw new IllegalArgumentException("'port' cannot be null.");
        }
        if (!DockingManager.isValidDockingRegion(region)) {
            throw new IllegalArgumentException("'" + region + "' is not a valid region.");
        }
        this.region = region;
        this.dockingPort = port;
        this.controllerInTopLeft = !DockingUtility.isRegionTopLeft(region);
        boolean weight = this.controllerInTopLeft;
        this.setResizeWeight((double)weight);
        this.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (DockingSplitPane.this.constantPercent && DockingSplitPane.this.getUI() instanceof BasicSplitPaneUI) {
                    BasicSplitPaneUI ui = (BasicSplitPaneUI)DockingSplitPane.this.getUI();
                    if (DockingSplitPane.this.dividerHashCode != ui.getDivider().hashCode()) {
                        DockingSplitPane.this.dividerHashCode = ui.getDivider().hashCode();
                        ui.getDivider().addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                DockingSplitPane.this.percent = SwingUtility.getDividerProportion(DockingSplitPane.this);
                                DockingSplitPane.this.setResizeWeight(DockingSplitPane.this.percent);
                            }
                        });
                    }
                }
            }
        });
        this.getActionMap().put("toggleFocus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtility.toggleFocus(1);
            }
        });
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.constantPercent) {
            this.setResizeWeight(this.percent);
            super.setDividerLocation((int)(this.percent * (double)this.getSplitSize()));
        }
    }

    public void setConstantPercent(boolean cstPercent) {
        if (cstPercent != this.constantPercent) {
            this.constantPercent = cstPercent;
        }
    }

    @Override
    public void resetToPreferredSizes() {
        Insets i = this.getInsets();
        if (this.getOrientation() == 0) {
            int bottomH;
            int topH;
            int h = this.getHeight() - i.top - i.bottom - this.getDividerSize();
            int extraSpace = h - (topH = this.getTopComponent().getPreferredSize().height) - (bottomH = this.getBottomComponent().getPreferredSize().height);
            if (extraSpace >= 0) {
                this.setDividerLocation(i.top + topH + (int)((double)extraSpace * this.getResizeWeight() + 0.5));
            }
        } else {
            int rightH;
            int leftH;
            int w = this.getWidth() - i.left - i.right - this.getDividerSize();
            int extraSpace = w - (leftH = this.getLeftComponent().getPreferredSize().width) - (rightH = this.getRightComponent().getPreferredSize().width);
            if (extraSpace >= 0) {
                this.setDividerLocation(i.left + leftH + (int)((double)extraSpace * this.getResizeWeight() + 0.5));
            }
        }
    }

    private int getSplitSize() {
        return this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
    }

    @Override
    public void setDividerLocation(double percent) {
        this.percent = percent;
        super.setDividerLocation(percent);
        this.setResizeWeight(percent);
    }

    public double getPercent() {
        if (this.constantPercent) {
            return this.percent;
        }
        return -1.0;
    }

    protected boolean isDividerSizeProperlyDetermined() {
        if (this.getDividerLocation() != 0) {
            return true;
        }
        return this.dividerLocDetermined;
    }

    public Component getElderComponent() {
        Component c;
        Component component = c = this.controllerInTopLeft ? this.getLeftComponent() : this.getRightComponent();
        if (c instanceof DockingPort) {
            c = ((DockingPort)((Object)c)).getDockedComponent();
        }
        return c;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isElderTopLeft() {
        return this.controllerInTopLeft;
    }

    @Override
    public void doLayout() {
        if (!this.isDividerSizeProperlyDetermined()) {
            this.dividerLocDetermined = true;
            this.setDividerLocation(this.initialDividerRatio);
        }
        super.doLayout();
    }

    public void cleanup() {
        this.dockingPort = null;
    }

    public void setInitialDividerRatio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("ratio (" + ratio + ") must be between [0.0,1,0] inclusive");
        }
        this.initialDividerRatio = ratio;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

