/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.props.PropertyChangeListenerFactory;

public class DockablePropertyChangeHandler
implements PropertyChangeListener {
    public static final DockablePropertyChangeHandler DEFAULT_INSTANCE = new DockablePropertyChangeHandler();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Dockable dockable;
        Dockable dockable2 = dockable = evt.getSource() instanceof Dockable ? (Dockable)evt.getSource() : null;
        if (dockable == null) {
            return;
        }
        if (evt.getPropertyName().equals("Dockable.TAB_ICON") || evt.getPropertyName().equals("Dockable.DESCRIPTION")) {
            DockingPort dockingPort;
            if (evt.getSource() instanceof Dockable && (dockingPort = dockable.getDockingPort()) instanceof DefaultDockingPort) {
                ((DefaultDockingPort)dockingPort).updateTab(dockable);
            }
        } else if ("Dockable.ACTIVE".equals(evt.getPropertyName())) {
            this.handleActivationChange(evt, dockable);
        }
    }

    private void handleActivationChange(PropertyChangeEvent evt, Dockable dockable) {
        if (Boolean.TRUE == evt.getNewValue() && ActiveDockableTracker.getActiveDockable() != dockable) {
            ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), true);
        }
    }

    public static class Factory
    extends PropertyChangeListenerFactory {
        @Override
        public PropertyChangeListener getListener() {
            return DEFAULT_INSTANCE;
        }
    }
}

