/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStub;
import org.flexdock.docking.adapter.DockingAdapter;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.util.Utilities;

public class DockableComponentWrapper
implements Dockable {
    private Component dragSrc;
    private String persistentId;
    private ArrayList dockingListeners;
    private ArrayList dragListeners;
    private Hashtable clientProperties;
    private HashSet frameDragSources;

    public static DockableComponentWrapper create(Component src, String id, String desc) {
        if (src == null || id == null) {
            return null;
        }
        return new DockableComponentWrapper(src, id, desc);
    }

    public static DockableComponentWrapper create(DockingStub stub) {
        if (!(stub instanceof Component)) {
            return null;
        }
        return DockableComponentWrapper.create((Component)((Object)stub), stub.getPersistentId(), stub.getTabText());
    }

    public static DockableComponentWrapper create(DockingAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        Component comp = adapter.getComponent();
        String id = adapter.getPersistentId();
        String tabText = adapter.getTabText();
        DockableComponentWrapper dockable = DockableComponentWrapper.create(comp, id, tabText);
        List dragSources = adapter.getDragSources();
        Set frameDragSources = adapter.getFrameDragSources();
        Icon icon = adapter.getDockbarIcon();
        if (dragSources != null) {
            dockable.getDragSources().clear();
            dockable.getDragSources().addAll(dragSources);
        }
        if (frameDragSources != null) {
            dockable.getFrameDragSources().clear();
            dockable.getFrameDragSources().addAll(frameDragSources);
        }
        if (icon != null) {
            dockable.getDockingProperties().setDockbarIcon(icon);
        }
        return dockable;
    }

    private DockableComponentWrapper(Component src, String id, String desc) {
        this.dragSrc = src;
        this.getDockingProperties().setDockableDesc(desc);
        this.persistentId = id;
        this.dockingListeners = new ArrayList(0);
        this.dragListeners = new ArrayList(1);
        this.initDragListeners();
    }

    private void initDragListeners() {
        Component draggable = this.dragSrc;
        Component frameDragger = null;
        if (this.dragSrc instanceof DockingStub) {
            DockingStub stub = (DockingStub)((Object)this.dragSrc);
            Component c = stub.getDragSource();
            if (c != null) {
                draggable = c;
            }
            frameDragger = stub.getFrameDragSource();
        }
        if (draggable != null) {
            this.dragListeners.add(draggable);
        }
        if (frameDragger != null) {
            this.getFrameDragSources().add(frameDragger);
        }
    }

    private Hashtable getInternalClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    @Override
    public Component getComponent() {
        return this.dragSrc;
    }

    @Override
    public List getDragSources() {
        return this.dragListeners;
    }

    @Override
    public String getPersistentId() {
        return this.persistentId;
    }

    @Override
    public Set getFrameDragSources() {
        if (this.frameDragSources == null) {
            this.frameDragSources = new HashSet();
        }
        return this.frameDragSources;
    }

    @Override
    public void addDockingListener(DockingListener listener) {
        if (listener != null) {
            this.dockingListeners.add(listener);
        }
    }

    @Override
    public DockingListener[] getDockingListeners() {
        return this.dockingListeners.toArray(new DockingListener[0]);
    }

    @Override
    public void removeDockingListener(DockingListener listener) {
        if (listener != null) {
            this.dockingListeners.remove(listener);
        }
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
    }

    @Override
    public void dockingComplete(DockingEvent evt) {
    }

    @Override
    public void undockingComplete(DockingEvent evt) {
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
    }

    @Override
    public void dragStarted(DockingEvent evt) {
    }

    @Override
    public void dropStarted(DockingEvent evt) {
    }

    @Override
    public Object getClientProperty(Object key) {
        if (key == null) {
            return null;
        }
        Component c = this.getComponent();
        if (c instanceof JComponent) {
            return ((JComponent)c).getClientProperty(key);
        }
        return this.getInternalClientProperties().get(key);
    }

    @Override
    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        Component c = this.getComponent();
        if (c instanceof JComponent) {
            SwingUtility.putClientProperty(c, key, value);
        } else {
            Utilities.put(this.getInternalClientProperties(), key, value);
        }
    }

    @Override
    public DockablePropertySet getDockingProperties() {
        return PropertyManager.getDockablePropertySet(this);
    }

    @Override
    public DockingPort getDockingPort() {
        return DockingManager.getDockingPort(this);
    }

    @Override
    public boolean dock(Dockable dockable) {
        return DockingManager.dock(dockable, this);
    }

    @Override
    public boolean dock(Dockable dockable, String relativeRegion) {
        return DockingManager.dock(dockable, this, relativeRegion);
    }

    @Override
    public boolean dock(Dockable dockable, String relativeRegion, float ratio) {
        return DockingManager.dock(dockable, this, relativeRegion, ratio);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getDockingProperties().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getDockingProperties().removePropertyChangeListener(listener);
    }
}

