/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.RegionChecker;

public class DefaultRegionChecker
implements RegionChecker,
DockingConstants {
    @Override
    public String getRegion(Component comp, Point point) {
        if (comp == null || point == null) {
            return "UNKNOWN";
        }
        Rectangle targetArea = comp.getBounds();
        if (comp instanceof DockingPort) {
            targetArea.setLocation(0, 0);
        }
        if (!targetArea.contains(point)) {
            return "UNKNOWN";
        }
        if (comp instanceof DockingPort) {
            return "CENTER";
        }
        Rectangle north = this.getNorthRegion(comp);
        int rightX = north.x + north.width;
        if (north.contains(point)) {
            Rectangle west = this.getWestRegion(comp);
            if (west.contains(point)) {
                Polygon westPoly = new Polygon();
                westPoly.addPoint(0, 0);
                westPoly.addPoint(0, north.height);
                westPoly.addPoint(west.width, north.height);
                return westPoly.contains(point) ? "WEST" : "NORTH";
            }
            Rectangle east = this.getEastRegion(comp);
            if (east.contains(point)) {
                Polygon eastPoly = new Polygon();
                eastPoly.addPoint(rightX, 0);
                eastPoly.addPoint(rightX, north.height);
                eastPoly.addPoint(east.x, north.height);
                return eastPoly.contains(point) ? "EAST" : "NORTH";
            }
            return "NORTH";
        }
        Rectangle south = this.getSouthRegion(comp);
        int bottomY = south.y + south.height;
        if (south.contains(point)) {
            Rectangle west = this.getWestRegion(comp);
            if (west.contains(point)) {
                Polygon westPoly = new Polygon();
                westPoly.addPoint(0, south.y);
                westPoly.addPoint(west.width, south.y);
                westPoly.addPoint(0, bottomY);
                return westPoly.contains(point) ? "WEST" : "SOUTH";
            }
            Rectangle east = this.getEastRegion(comp);
            if (east.contains(point)) {
                Polygon eastPoly = new Polygon();
                eastPoly.addPoint(east.y, south.y);
                eastPoly.addPoint(rightX, south.y);
                eastPoly.addPoint(rightX, bottomY);
                return eastPoly.contains(point) ? "EAST" : "SOUTH";
            }
            return "SOUTH";
        }
        Rectangle east = this.getEastRegion(comp);
        if (east.contains(point)) {
            return "EAST";
        }
        Rectangle west = this.getWestRegion(comp);
        if (west.contains(point)) {
            return "WEST";
        }
        return "CENTER";
    }

    @Override
    public Rectangle getNorthRegion(Component c) {
        return this.getRegionBounds(c, "NORTH");
    }

    @Override
    public Rectangle getSouthRegion(Component c) {
        return this.getRegionBounds(c, "SOUTH");
    }

    @Override
    public Rectangle getEastRegion(Component c) {
        return this.getRegionBounds(c, "EAST");
    }

    @Override
    public Rectangle getWestRegion(Component c) {
        return this.getRegionBounds(c, "WEST");
    }

    @Override
    public Rectangle getRegionBounds(Component c, String region) {
        if (c != null && region != null) {
            float size = this.getRegionSize(c, region);
            return this.calculateRegionalBounds(c, region, size);
        }
        return null;
    }

    @Override
    public Rectangle getSiblingBounds(Component c, String region) {
        if (c != null && region != null) {
            float size = this.getSiblingSize(c, region);
            return this.calculateRegionalBounds(c, region, size);
        }
        return null;
    }

    protected Rectangle calculateRegionalBounds(Component c, String region, float size) {
        if (c == null || region == null) {
            return null;
        }
        Rectangle bounds = c.getBounds();
        if ("NORTH".equals(region) || "SOUTH".equals(region)) {
            int h = (int)((float)bounds.height * size);
            int y = "NORTH".equals(region) ? 0 : bounds.height - h;
            return new Rectangle(0, y, bounds.width, h);
        }
        if ("WEST".equals(region) || "EAST".equals(region)) {
            int w = (int)((float)bounds.width * size);
            int x = "WEST".equals(region) ? 0 : bounds.width - w;
            return new Rectangle(x, 0, w, bounds.height);
        }
        return null;
    }

    @Override
    public float getRegionSize(Component c, String region) {
        Dockable d = DockingManager.getDockable(c);
        return DefaultRegionChecker.getRegionPreference(d, region);
    }

    @Override
    public float getSiblingSize(Component c, String region) {
        Dockable d = DockingManager.getDockable(c);
        return DefaultRegionChecker.getSiblingPreference(d, region);
    }

    protected static float getDockingInset(Float value, float defaultVal, float max, float min) {
        float f;
        float f2 = f = value == null ? -1.0f : value.floatValue();
        if (f == -1.0f) {
            f = defaultVal;
        }
        return DefaultRegionChecker.checkBounds(f, max, min);
    }

    protected static float checkBounds(float val, float max, float min) {
        val = Math.min(val, max);
        return Math.max(val, min);
    }

    public static float validateRegionSize(float size) {
        return DefaultRegionChecker.checkBounds(size, 0.5f, 0.0f);
    }

    public static float validateSiblingSize(float size) {
        return DefaultRegionChecker.checkBounds(size, 1.0f, 0.0f);
    }

    public static float getRegionPreference(Dockable d, String region) {
        Float inset = d == null ? null : d.getDockingProperties().getRegionInset(region);
        return DefaultRegionChecker.getDockingInset(inset, 0.25f, 0.5f, 0.0f);
    }

    public static float getSiblingPreference(Dockable d, String region) {
        Float size = d == null ? null : d.getDockingProperties().getSiblingSize(region);
        return DefaultRegionChecker.getDockingInset(size, DockingManager.getDefaultSiblingSize(), 1.0f, 0.0f);
    }
}

