/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.util.Utilities;

public abstract class AbstractDockable
implements Dockable {
    private String persistentId;
    private ArrayList dockingListeners;
    private ArrayList dragListeners;
    private Hashtable clientProperties;
    private HashSet frameDragSources;

    public AbstractDockable(String id) {
        this.persistentId = id;
        this.dockingListeners = new ArrayList(2);
        this.dragListeners = new ArrayList();
        this.clientProperties = new Hashtable(2);
        this.dragListeners.add(this.getComponent());
    }

    @Override
    public abstract Component getComponent();

    @Override
    public List getDragSources() {
        return this.dragListeners;
    }

    @Override
    public String getPersistentId() {
        return this.persistentId;
    }

    @Override
    public Set getFrameDragSources() {
        if (this.frameDragSources == null) {
            this.frameDragSources = new HashSet();
        }
        return this.frameDragSources;
    }

    public void setTabText(String tabText) {
        this.getDockingProperties().setDockableDesc(tabText);
    }

    public String getTabText() {
        return this.getDockingProperties().getDockableDesc();
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
    }

    @Override
    public void dockingComplete(DockingEvent evt) {
    }

    @Override
    public void dragStarted(DockingEvent evt) {
    }

    @Override
    public void dropStarted(DockingEvent evt) {
    }

    @Override
    public void undockingComplete(DockingEvent evt) {
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
    }

    @Override
    public void addDockingListener(DockingListener listener) {
        if (listener != null) {
            this.dockingListeners.add(listener);
        }
    }

    @Override
    public DockingListener[] getDockingListeners() {
        return this.dockingListeners.toArray(new DockingListener[0]);
    }

    @Override
    public void removeDockingListener(DockingListener listener) {
        if (listener != null) {
            this.dockingListeners.remove(listener);
        }
    }

    @Override
    public Object getClientProperty(Object key) {
        if (key == null) {
            return null;
        }
        Component c = this.getComponent();
        if (c instanceof JComponent) {
            return ((JComponent)c).getClientProperty(key);
        }
        return this.clientProperties.get(key);
    }

    @Override
    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        Component c = this.getComponent();
        if (c instanceof JComponent) {
            SwingUtility.putClientProperty(c, key, value);
        } else {
            Utilities.put(this.clientProperties, key, value);
        }
    }

    @Override
    public DockablePropertySet getDockingProperties() {
        return PropertyManager.getDockablePropertySet(this);
    }

    @Override
    public DockingPort getDockingPort() {
        return DockingManager.getDockingPort(this);
    }

    @Override
    public boolean dock(Dockable dockable) {
        return DockingManager.dock(dockable, this);
    }

    @Override
    public boolean dock(Dockable dockable, String relativeRegion) {
        return DockingManager.dock(dockable, this, relativeRegion);
    }

    @Override
    public boolean dock(Dockable dockable, String relativeRegion, float ratio) {
        return DockingManager.dock(dockable, this, relativeRegion, ratio);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getDockingProperties().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getDockingProperties().removePropertyChangeListener(listener);
    }
}

