/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.execution.tools;

import com.google.common.collect.ImmutableMap;
import de.richtercloud.execution.tools.OutputReaderThread;
import de.richtercloud.execution.tools.OutputReaderThreadMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JK\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0015\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0016JU\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0015\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0018Jm\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0015\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u001cJK\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0015\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lde/richtercloud/execution/tools/ExecutionUtils;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PATH_TEMPLATE", "", "SH_DEFAULT", "getSH_DEFAULT", "()Ljava/lang/String;", "createProcess", "Lorg/apache/commons/lang3/tuple/Triple;", "Ljava/lang/Process;", "Lde/richtercloud/execution/tools/OutputReaderThread;", "directory", "Ljava/io/File;", "stdoutOutputStream", "Ljava/io/OutputStream;", "stderrOutputStream", "commands", "", "(Ljava/io/File;Ljava/io/OutputStream;Ljava/io/OutputStream;[Ljava/lang/String;)Lorg/apache/commons/lang3/tuple/Triple;", "path", "(Ljava/io/File;Ljava/lang/String;Ljava/io/OutputStream;Ljava/io/OutputStream;[Ljava/lang/String;)Lorg/apache/commons/lang3/tuple/Triple;", "env", "", "sh", "(Ljava/io/File;Ljava/util/Map;Ljava/lang/String;Ljava/io/OutputStream;Ljava/io/OutputStream;[Ljava/lang/String;)Lorg/apache/commons/lang3/tuple/Triple;", "(Ljava/lang/String;Ljava/io/OutputStream;Ljava/io/OutputStream;[Ljava/lang/String;)Lorg/apache/commons/lang3/tuple/Triple;", "execution-tools"})
public final class ExecutionUtils {
    private static final Logger LOGGER;
    @NotNull
    private static final String SH_DEFAULT = "sh";
    private static final String PATH_TEMPLATE = "PATH";
    public static final ExecutionUtils INSTANCE;

    @NotNull
    public final String getSH_DEFAULT() {
        return SH_DEFAULT;
    }

    @JvmStatic
    @NotNull
    public static final Triple<Process, OutputReaderThread, OutputReaderThread> createProcess(@NotNull String path, @NotNull OutputStream stdoutOutputStream, @NotNull OutputStream stderrOutputStream, String ... commands) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)stdoutOutputStream, (String)"stdoutOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)stderrOutputStream, (String)"stderrOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)commands, (String)"commands");
        return ExecutionUtils.createProcess(null, path, stdoutOutputStream, stderrOutputStream, Arrays.copyOf(commands, commands.length));
    }

    @JvmStatic
    @NotNull
    public static final Triple<Process, OutputReaderThread, OutputReaderThread> createProcess(@NotNull File directory, @NotNull OutputStream stdoutOutputStream, @NotNull OutputStream stderrOutputStream, String ... commands) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)stdoutOutputStream, (String)"stdoutOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)stderrOutputStream, (String)"stderrOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)commands, (String)"commands");
        String string = System.getenv(PATH_TEMPLATE);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getenv(PATH_TEMPLATE)");
        return ExecutionUtils.createProcess(directory, string, stdoutOutputStream, stderrOutputStream, Arrays.copyOf(commands, commands.length));
    }

    @JvmStatic
    @NotNull
    public static final Triple<Process, OutputReaderThread, OutputReaderThread> createProcess(@Nullable File directory, @NotNull String path, @NotNull OutputStream stdoutOutputStream, @NotNull OutputStream stderrOutputStream, String ... commands) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)stdoutOutputStream, (String)"stdoutOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)stderrOutputStream, (String)"stderrOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)commands, (String)"commands");
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)PATH_TEMPLATE, (Object)path).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.builder<Str\u2026                 .build()");
        return ExecutionUtils.createProcess(directory, (Map)immutableMap, SH_DEFAULT, stdoutOutputStream, stderrOutputStream, Arrays.copyOf(commands, commands.length));
    }

    @JvmStatic
    @NotNull
    public static final Triple<Process, OutputReaderThread, OutputReaderThread> createProcess(@Nullable File directory, @NotNull Map<String, String> env, @NotNull String sh, @Nullable OutputStream stdoutOutputStream, @Nullable OutputStream stderrOutputStream, String ... commands) throws IOException {
        String string;
        Logger logger;
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)sh, (String)SH_DEFAULT);
        Intrinsics.checkParameterIsNotNull((Object)commands, (String)"commands");
        Logger logger2 = LOGGER;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "building process with commands '%s' with environment '%s' running in %s";
        Object[] objectArray3 = new Object[3];
        objectArray3[0] = Arrays.asList(Arrays.copyOf(commands, commands.length));
        objectArray3[1] = env;
        Object[] objectArray4 = objectArray3;
        Object[] objectArray5 = objectArray3;
        int n = 2;
        if (directory != null) {
            objectArray2 = StringCompanionObject.INSTANCE;
            String string3 = "directory '%s'";
            Object[] objectArray6 = new Object[]{directory.getAbsolutePath()};
            int n2 = n;
            Object[] objectArray7 = objectArray4;
            objectArray = objectArray5;
            logger = logger2;
            String string4 = String.format(string3, Arrays.copyOf(objectArray6, objectArray6.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String string5 = string4;
            logger2 = logger;
            objectArray5 = objectArray;
            objectArray4 = objectArray7;
            n = n2;
            string = string5;
        } else {
            string = "current directory";
        }
        objectArray4[n] = string;
        objectArray2 = objectArray5;
        logger = logger2;
        Object[] objectArray8 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray8, (String)"java.lang.String.format(format, *args)");
        objectArray = objectArray8;
        logger.trace((String)objectArray);
        ProcessBuilder processBuilder = new ProcessBuilder(sh, "-c", ArraysKt.joinToString$default((Object[])commands, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).redirectOutput(stdoutOutputStream != null ? ProcessBuilder.Redirect.PIPE : ProcessBuilder.Redirect.INHERIT).redirectError(stderrOutputStream != null ? ProcessBuilder.Redirect.PIPE : ProcessBuilder.Redirect.INHERIT);
        if (directory != null) {
            processBuilder.directory(directory);
        }
        processBuilder.environment().putAll(env);
        Process retValue = processBuilder.start();
        OutputReaderThread stdoutReaderThread = null;
        OutputReaderThread stderrReaderThread = null;
        if (stdoutOutputStream != null) {
            Process process = retValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"retValue");
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"retValue.inputStream");
            stdoutReaderThread = new OutputReaderThread(inputStream, OutputReaderThreadMode.OUTPUT_STREAM, stdoutOutputStream, null, 8, null);
            stdoutReaderThread.start();
        }
        if (stderrOutputStream != null) {
            Process process = retValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"retValue");
            InputStream inputStream = process.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"retValue.errorStream");
            stderrReaderThread = new OutputReaderThread(inputStream, OutputReaderThreadMode.OUTPUT_STREAM, stderrOutputStream, null, 8, null);
            stderrReaderThread.start();
        }
        return (Triple)new ImmutableTriple((Object)retValue, (Object)stdoutReaderThread, (Object)stderrReaderThread);
    }

    private ExecutionUtils() {
    }

    static {
        ExecutionUtils executionUtils;
        INSTANCE = executionUtils = new ExecutionUtils();
        LOGGER = LoggerFactory.getLogger(ExecutionUtils.class);
        SH_DEFAULT = SH_DEFAULT;
        PATH_TEMPLATE = PATH_TEMPLATE;
    }
}

