/**
 * Copyright 2018 Karl-Philipp Richter
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.richtercloud.equals.lambda;

/**
 * Used by
 * {@link EqualsLambda#equals(java.lang.Object, java.lang.Object, richtercloud.project1.jar.controller.EqualsCheck) }.
 *
 * @author richter
 * @param <T> the type to compare for equality
 */
@FunctionalInterface
public interface EqualsCheck<T> {

    public static <T> EqualsCheck<T> alwaysTrue() {
        EqualsCheck<T> retValue = (a,b) -> {
            return true;
        };
        return retValue;
    }

    boolean equals(T a, T b);
}
