/*
 * Decompiled with CFR 0.152.
 */
package de.rhocas.featuregen.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.rhocas.featuregen.featureide.model.configuration.Configuration;
import de.rhocas.featuregen.featureide.model.configuration.Feature;
import de.rhocas.featuregen.featureide.model.feature.BranchedFeatureType;
import de.rhocas.featuregen.featureide.model.feature.FeatureModel;
import de.rhocas.featuregen.featureide.model.feature.FeatureModelType;
import de.rhocas.featuregen.featureide.model.feature.FeatureType;
import de.rhocas.featuregen.featureide.model.feature.StructType;
import de.rhocas.featuregen.generator.FeatureNameConverter;
import de.rhocas.featuregen.generator.GeneratorHelper;
import de.rhocas.featuregen.generator.NameProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public final class FeatureIDEVariantGenerator {
    public static void main(String[] args) {
        FeatureIDEVariantGenerator generator = new FeatureIDEVariantGenerator();
        generator.generate(args);
    }

    public void generate(String[] args) {
        Parameters parameters = this.convertAndCheckParameters(args);
        this.generateVariantClass(parameters);
    }

    private Parameters convertAndCheckParameters(String[] args) {
        boolean _not_1;
        boolean _not;
        boolean _lessThan;
        Parameters _xblockexpression = null;
        int _size = ((List)Conversions.doWrapArray((Object)args)).size();
        boolean bl = _lessThan = _size < 6;
        if (_lessThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid number of arguments. Expected at least 6, but was ");
            int _size_1 = ((List)Conversions.doWrapArray((Object)args)).size();
            _builder.append((Object)_size_1);
            _builder.append(".");
            throw new IllegalArgumentException(_builder.toString());
        }
        String configurationModelFilePath = args[0];
        File configurationModelFile = new File(configurationModelFilePath);
        boolean _isFile = configurationModelFile.isFile();
        boolean bl2 = _not = !_isFile;
        if (_not) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Model file \"");
            _builder_1.append(configurationModelFilePath);
            _builder_1.append("\" can not be found.");
            throw new IllegalArgumentException(_builder_1.toString());
        }
        Configuration configurationModel = this.readConfigurationModel(configurationModelFile);
        String featureModelFilePath = args[1];
        File featureModelFile = new File(featureModelFilePath);
        boolean _isFile_1 = featureModelFile.isFile();
        boolean bl3 = _not_1 = !_isFile_1;
        if (_not_1) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Model file \"");
            _builder_2.append(featureModelFilePath);
            _builder_2.append("\" can not be found.");
            throw new IllegalArgumentException(_builder_2.toString());
        }
        FeatureModelType featureModel = this.readFeatureModel(featureModelFile);
        String outputFolderPath = args[2];
        File outputFolder = new File(outputFolderPath);
        String packageName = args[3];
        String className = args[4];
        String featuresPackageName = args[5];
        String _xifexpression = null;
        int _size_2 = ((List)Conversions.doWrapArray((Object)args)).size();
        boolean _greaterEqualsThan = _size_2 >= 7;
        _xifexpression = _greaterEqualsThan ? args[6] : "";
        String prefix = _xifexpression;
        String _xifexpression_1 = null;
        int _size_3 = ((List)Conversions.doWrapArray((Object)args)).size();
        boolean _greaterEqualsThan_1 = _size_3 >= 8;
        _xifexpression_1 = _greaterEqualsThan_1 ? args[7] : "_FEATURE";
        String suffix = _xifexpression_1;
        _xblockexpression = new Parameters(configurationModel, featureModel, packageName, className, outputFolder, featuresPackageName, prefix, suffix);
        return _xblockexpression;
    }

    private Configuration readConfigurationModel(File modelFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object _unmarshal = unmarshaller.unmarshal(modelFile);
            return (Configuration)_unmarshal;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private FeatureModelType readFeatureModel(File modelFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FeatureModel.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object _unmarshal = unmarshaller.unmarshal(modelFile);
            return (FeatureModelType)_unmarshal;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void generateVariantClass(Parameters parameters) {
        boolean _notEquals;
        NameProvider nameProvider = new NameProvider();
        FeatureNameConverter featureNameConverter = new FeatureNameConverter();
        String rootName = this.getRoot(parameters.configurationModel).getName();
        String simpleName = parameters.className;
        Functions.Function1 _function = it -> it.getName();
        List abstractFeatures = ListExtensions.map(this.findAbstractFeatures(this.getRoot(parameters.featureModel)), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> Objects.equal((Object)it.getAutomatic(), (Object)"selected") || Objects.equal((Object)it.getManual(), (Object)"selected");
        Functions.Function1 _function_2 = it -> it.getName();
        Functions.Function1 _function_3 = it -> {
            boolean _contains = abstractFeatures.contains(it);
            return !_contains;
        };
        Functions.Function1 _function_4 = it -> featureNameConverter.convertToValidSimpleFeatureName((String)it, parameters.prefix, parameters.suffix);
        Functions.Function1 _function_5 = it -> {
            String _simpleFeaturesEnumName = nameProvider.getSimpleFeaturesEnumName(rootName);
            String _plus = _simpleFeaturesEnumName + ".";
            return _plus + it;
        };
        Iterable selectedFeatures = IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)parameters.configurationModel.getFeature(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
        File outputFile = this.prepareOutputFile(parameters);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(parameters.packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean bl = _notEquals = !Objects.equal((Object)parameters.packageName, (Object)parameters.featuresPackageName);
        if (_notEquals) {
            _builder.append("import ");
            _builder.append(parameters.featuresPackageName);
            _builder.append(".");
            String _simpleVariantInterfaceName = nameProvider.getSimpleVariantInterfaceName(rootName);
            _builder.append(_simpleVariantInterfaceName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("import ");
            _builder.append(parameters.featuresPackageName);
            _builder.append(".");
            String _simpleSelectedFeaturesAnnotationName = nameProvider.getSimpleSelectedFeaturesAnnotationName(rootName);
            _builder.append(_simpleSelectedFeaturesAnnotationName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("import ");
            _builder.append(parameters.featuresPackageName);
            _builder.append(".");
            String _simpleFeaturesEnumName = nameProvider.getSimpleFeaturesEnumName(rootName);
            _builder.append(_simpleFeaturesEnumName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append("@");
        String _simpleSelectedFeaturesAnnotationName_1 = nameProvider.getSimpleSelectedFeaturesAnnotationName(rootName);
        _builder.append(_simpleSelectedFeaturesAnnotationName_1);
        _builder.append("( {");
        String _join = IterableExtensions.join((Iterable)selectedFeatures, (CharSequence)", ");
        _builder.append(_join);
        _builder.append("} )");
        _builder.newLineIfNotEmpty();
        _builder.append("public final class ");
        _builder.append(simpleName);
        _builder.append(" implements ");
        String _simpleVariantInterfaceName_1 = nameProvider.getSimpleVariantInterfaceName(rootName);
        _builder.append(_simpleVariantInterfaceName_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        _builder.append(simpleName, "\t");
        _builder.append("( ) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String fileContent = _builder.toString();
        GeneratorHelper generatorHelper = new GeneratorHelper();
        generatorHelper.writeContentToFileIfChanged(fileContent, outputFile);
    }

    private FeatureType getRoot(FeatureModelType model) {
        boolean _tripleNotEquals;
        FeatureType _xblockexpression = null;
        StructType struct = model.getStruct();
        FeatureType _xifexpression = null;
        FeatureType _feature = struct.getFeature();
        boolean bl = _tripleNotEquals = _feature != null;
        if (_tripleNotEquals) {
            _xifexpression = struct.getFeature();
        } else {
            boolean _tripleNotEquals_1;
            BranchedFeatureType _xifexpression_1 = null;
            BranchedFeatureType _and = struct.getAnd();
            boolean bl2 = _tripleNotEquals_1 = _and != null;
            if (_tripleNotEquals_1) {
                _xifexpression_1 = struct.getAnd();
            } else {
                BranchedFeatureType _xifexpression_2 = null;
                BranchedFeatureType _or = struct.getOr();
                boolean _tripleNotEquals_2 = _or != null;
                _xifexpression_2 = _tripleNotEquals_2 ? struct.getOr() : struct.getAlt();
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private List<FeatureType> findAbstractFeatures(FeatureType type) {
        ArrayList<FeatureType> _xblockexpression = null;
        ArrayList<FeatureType> features = new ArrayList<FeatureType>();
        if (type != null) {
            boolean _equals = Boolean.TRUE.equals(type.isAbstract());
            if (_equals) {
                features.add(type);
            }
            if (type instanceof BranchedFeatureType) {
                List _andOrOrOrAlt = ((BranchedFeatureType)type).getAndOrOrOrAlt();
                for (JAXBElement feature : _andOrOrOrAlt) {
                    List<FeatureType> _findAbstractFeatures = this.findAbstractFeatures((FeatureType)feature.getValue());
                    Iterables.addAll(features, _findAbstractFeatures);
                }
            }
        }
        _xblockexpression = features;
        return _xblockexpression;
    }

    private Feature getRoot(Configuration configurationModel) {
        Feature _xblockexpression = null;
        List features = configurationModel.getFeature();
        _xblockexpression = (Feature)IterableExtensions.head((Iterable)features);
        return _xblockexpression;
    }

    private File prepareOutputFile(Parameters parameters) {
        File _xblockexpression = null;
        String packagePath = parameters.packageName.replace(".", "/");
        File outputFileParent = new File(parameters.outputFolder, packagePath);
        outputFileParent.mkdirs();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(parameters.className);
        _builder.append(".java");
        _xblockexpression = new File(outputFileParent, _builder.toString());
        return _xblockexpression;
    }

    @Accessors(value={AccessorType.NONE})
    private static final class Parameters {
        private final Configuration configurationModel;
        private final FeatureModelType featureModel;
        private final String packageName;
        private final String className;
        private final File outputFolder;
        private final String featuresPackageName;
        private final String prefix;
        private final String suffix;

        public Parameters(Configuration configurationModel, FeatureModelType featureModel, String packageName, String className, File outputFolder, String featuresPackageName, String prefix, String suffix) {
            this.configurationModel = configurationModel;
            this.featureModel = featureModel;
            this.packageName = packageName;
            this.className = className;
            this.outputFolder = outputFolder;
            this.featuresPackageName = featuresPackageName;
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }
}

